/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.AbstractByteCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteArrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteConsumer;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteIterators;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteList;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteListIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteSpliterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteSpliterators;

public abstract class AbstractByteList
extends AbstractByteCollection
implements ByteList {
    protected AbstractByteList() {
    }

    protected void ensureIndex(int index2) {
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is negative");
        }
        if (index2 > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than list size (" + this.size() + ")");
        }
    }

    protected void ensureRestrictedIndex(int index2) {
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is negative");
        }
        if (index2 >= this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than or equal to list size (" + this.size() + ")");
        }
    }

    @Override
    public void add(int index2, byte k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(byte k) {
        this.add(this.size(), k);
        return true;
    }

    @Override
    public byte removeByte(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte set(int index2, byte k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index2, Collection<? extends Byte> c) {
        if (c instanceof ByteCollection) {
            return this.addAll(index2, (ByteCollection)c);
        }
        this.ensureIndex(index2);
        Iterator<? extends Byte> i = c.iterator();
        boolean retVal = i.hasNext();
        while (i.hasNext()) {
            this.add(index2++, (byte)i.next());
        }
        return retVal;
    }

    @Override
    public boolean addAll(Collection<? extends Byte> c) {
        return this.addAll(this.size(), c);
    }

    @Override
    public ByteListIterator iterator() {
        return this.listIterator();
    }

    @Override
    public ByteListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ByteListIterator listIterator(int index2) {
        this.ensureIndex(index2);
        return new ByteIterators.AbstractIndexBasedListIterator(0, index2){

            @Override
            protected final byte get(int i) {
                return AbstractByteList.this.getByte(i);
            }

            @Override
            protected final void add(int i, byte k) {
                AbstractByteList.this.add(i, k);
            }

            @Override
            protected final void set(int i, byte k) {
                AbstractByteList.this.set(i, k);
            }

            @Override
            protected final void remove(int i) {
                AbstractByteList.this.removeByte(i);
            }

            @Override
            protected final int getMaxPos() {
                return AbstractByteList.this.size();
            }
        };
    }

    @Override
    public boolean contains(byte k) {
        return this.indexOf(k) >= 0;
    }

    @Override
    public int indexOf(byte k) {
        ByteListIterator i = this.listIterator();
        while (i.hasNext()) {
            byte e = i.nextByte();
            if (k != e) continue;
            return i.previousIndex();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(byte k) {
        ByteListIterator i = this.listIterator(this.size());
        while (i.hasPrevious()) {
            byte e = i.previousByte();
            if (k != e) continue;
            return i.nextIndex();
        }
        return -1;
    }

    @Override
    public ByteList subList(int from, int to) {
        this.ensureIndex(from);
        this.ensureIndex(to);
        if (from > to) {
            throw new IndexOutOfBoundsException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        return this instanceof RandomAccess ? new ByteRandomAccessSubList(this, from, to) : new ByteSubList(this, from, to);
    }

    @Override
    public void forEach(ByteConsumer action) {
        if (this instanceof RandomAccess) {
            int max = this.size();
            for (int i = 0; i < max; ++i) {
                action.accept(this.getByte(i));
            }
        } else {
            ByteList.super.forEach(action);
        }
    }

    @Override
    public void removeElements(int from, int to) {
        this.ensureIndex(to);
        ByteListIterator i = this.listIterator(from);
        int n = to - from;
        if (n < 0) {
            throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        while (n-- != 0) {
            i.nextByte();
            i.remove();
        }
    }

    @Override
    public void getElements(int from, byte[] a, int offset, int length) {
        this.ensureIndex(from);
        ByteArrays.ensureOffsetLength(a, offset, length);
        if (from + length > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (from + length) + ") is greater than list size (" + this.size() + ")");
        }
        if (this instanceof RandomAccess) {
            int current = from;
            while (length-- != 0) {
                a[offset++] = this.getByte(current++);
            }
        } else {
            ByteListIterator i = this.listIterator(from);
            while (length-- != 0) {
                a[offset++] = i.nextByte();
            }
        }
    }

    @Override
    public void setElements(int index2, byte[] a, int offset, int length) {
        this.ensureIndex(index2);
        ByteArrays.ensureOffsetLength(a, offset, length);
        if (index2 + length > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (index2 + length) + ") is greater than list size (" + this.size() + ")");
        }
        if (this instanceof RandomAccess) {
            for (int i = 0; i < length; ++i) {
                this.set(i + index2, a[i + offset]);
            }
        } else {
            ByteListIterator iter = this.listIterator(index2);
            int i = 0;
            while (i < length) {
                iter.nextByte();
                iter.set(a[offset + i++]);
            }
        }
    }

    @Override
    public void clear() {
        this.removeElements(0, this.size());
    }

    @Override
    public int hashCode() {
        ByteListIterator i = this.iterator();
        int h = 1;
        int s = this.size();
        while (s-- != 0) {
            byte k = i.nextByte();
            h = 31 * h + k;
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List l = (List)o;
        int s = this.size();
        if (s != l.size()) {
            return false;
        }
        if (l instanceof ByteList) {
            ByteListIterator i1 = this.listIterator();
            ByteListIterator i2 = ((ByteList)l).listIterator();
            while (s-- != 0) {
                if (i1.nextByte() == i2.nextByte()) continue;
                return false;
            }
            return true;
        }
        ByteListIterator i1 = this.listIterator();
        ListIterator i2 = l.listIterator();
        while (s-- != 0) {
            if (Objects.equals(i1.next(), i2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(List<? extends Byte> l) {
        if (l == this) {
            return 0;
        }
        if (l instanceof ByteList) {
            ByteListIterator i1 = this.listIterator();
            ByteListIterator i2 = ((ByteList)l).listIterator();
            while (i1.hasNext() && i2.hasNext()) {
                byte e2;
                byte e1 = i1.nextByte();
                int r = Byte.compare(e1, e2 = i2.nextByte());
                if (r == 0) continue;
                return r;
            }
            return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
        }
        ByteListIterator i1 = this.listIterator();
        ListIterator<? extends Byte> i2 = l.listIterator();
        while (i1.hasNext() && i2.hasNext()) {
            int r = ((Comparable)i1.next()).compareTo(i2.next());
            if (r == 0) continue;
            return r;
        }
        return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
    }

    @Override
    public boolean rem(byte k) {
        int index2 = this.indexOf(k);
        if (index2 == -1) {
            return false;
        }
        this.removeByte(index2);
        return true;
    }

    @Override
    public byte[] toByteArray() {
        int size = this.size();
        byte[] ret = new byte[size];
        this.getElements(0, ret, 0, size);
        return ret;
    }

    @Override
    public byte[] toArray(byte[] a) {
        int size = this.size();
        if (a.length < size) {
            a = Arrays.copyOf(a, size);
        }
        this.getElements(0, a, 0, size);
        return a;
    }

    public boolean addAll(int index2, ByteCollection c) {
        this.ensureIndex(index2);
        ByteIterator i = c.iterator();
        boolean retVal = i.hasNext();
        while (i.hasNext()) {
            this.add(index2++, i.nextByte());
        }
        return retVal;
    }

    @Override
    public boolean addAll(ByteCollection c) {
        return this.addAll(this.size(), c);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        ByteListIterator i = this.iterator();
        int n = this.size();
        boolean first = true;
        s.append("[");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            byte k = i.nextByte();
            s.append(String.valueOf(k));
        }
        s.append("]");
        return s.toString();
    }

    public static class ByteRandomAccessSubList
    extends ByteSubList
    implements RandomAccess {
        private static final long serialVersionUID = -107070782945191929L;

        public ByteRandomAccessSubList(ByteList l, int from, int to) {
            super(l, from, to);
        }

        @Override
        public ByteList subList(int from, int to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            if (from > to) {
                throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
            }
            return new ByteRandomAccessSubList(this, from, to);
        }
    }

    public static class ByteSubList
    extends AbstractByteList
    implements Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final ByteList l;
        protected final int from;
        protected int to;

        public ByteSubList(ByteList l, int from, int to) {
            this.l = l;
            this.from = from;
            this.to = to;
        }

        private boolean assertRange() {
            assert (this.from <= this.l.size());
            assert (this.to <= this.l.size());
            assert (this.to >= this.from);
            return true;
        }

        @Override
        public boolean add(byte k) {
            this.l.add(this.to, k);
            ++this.to;
            assert (this.assertRange());
            return true;
        }

        @Override
        public void add(int index2, byte k) {
            this.ensureIndex(index2);
            this.l.add(this.from + index2, k);
            ++this.to;
            assert (this.assertRange());
        }

        @Override
        public boolean addAll(int index2, Collection<? extends Byte> c) {
            this.ensureIndex(index2);
            this.to += c.size();
            return this.l.addAll(this.from + index2, c);
        }

        @Override
        public byte getByte(int index2) {
            this.ensureRestrictedIndex(index2);
            return this.l.getByte(this.from + index2);
        }

        @Override
        public byte removeByte(int index2) {
            this.ensureRestrictedIndex(index2);
            --this.to;
            return this.l.removeByte(this.from + index2);
        }

        @Override
        public byte set(int index2, byte k) {
            this.ensureRestrictedIndex(index2);
            return this.l.set(this.from + index2, k);
        }

        @Override
        public int size() {
            return this.to - this.from;
        }

        @Override
        public void getElements(int from, byte[] a, int offset, int length) {
            this.ensureIndex(from);
            if (from + length > this.size()) {
                throw new IndexOutOfBoundsException("End index (" + from + length + ") is greater than list size (" + this.size() + ")");
            }
            this.l.getElements(this.from + from, a, offset, length);
        }

        @Override
        public void removeElements(int from, int to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            this.l.removeElements(this.from + from, this.from + to);
            this.to -= to - from;
            assert (this.assertRange());
        }

        @Override
        public void setElements(int index2, byte[] a, int offset, int length) {
            this.ensureIndex(index2);
            this.l.setElements(this.from + index2, a, offset, length);
            assert (this.assertRange());
        }

        @Override
        public ByteListIterator listIterator(int index2) {
            this.ensureIndex(index2);
            return this.l instanceof RandomAccess ? new RandomAccessIter(index2) : new ParentWrappingIter(this.l.listIterator(index2 + this.from));
        }

        @Override
        public ByteSpliterator spliterator() {
            return this.l instanceof RandomAccess ? new IndexBasedSpliterator(this.l, this.from, this.to) : super.spliterator();
        }

        @Override
        public ByteList subList(int from, int to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            if (from > to) {
                throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
            }
            return new ByteSubList(this, from, to);
        }

        @Override
        public boolean rem(byte k) {
            int index2 = this.indexOf(k);
            if (index2 == -1) {
                return false;
            }
            --this.to;
            this.l.removeByte(this.from + index2);
            assert (this.assertRange());
            return true;
        }

        @Override
        public boolean addAll(int index2, ByteCollection c) {
            this.ensureIndex(index2);
            return super.addAll(index2, c);
        }

        private final class RandomAccessIter
        extends ByteIterators.AbstractIndexBasedListIterator {
            RandomAccessIter(int pos) {
                super(0, pos);
            }

            @Override
            protected final byte get(int i) {
                return ByteSubList.this.l.getByte(ByteSubList.this.from + i);
            }

            @Override
            protected final void add(int i, byte k) {
                ByteSubList.this.add(i, k);
            }

            @Override
            protected final void set(int i, byte k) {
                ByteSubList.this.set(i, k);
            }

            @Override
            protected final void remove(int i) {
                ByteSubList.this.removeByte(i);
            }

            @Override
            protected final int getMaxPos() {
                return ByteSubList.this.to - ByteSubList.this.from;
            }

            @Override
            public void add(byte k) {
                super.add(k);
                assert (ByteSubList.this.assertRange());
            }

            @Override
            public void remove() {
                super.remove();
                assert (ByteSubList.this.assertRange());
            }
        }

        private class ParentWrappingIter
        implements ByteListIterator {
            private ByteListIterator parent;

            ParentWrappingIter(ByteListIterator parent2) {
                this.parent = parent2;
            }

            @Override
            public int nextIndex() {
                return this.parent.nextIndex() - ByteSubList.this.from;
            }

            @Override
            public int previousIndex() {
                return this.parent.previousIndex() - ByteSubList.this.from;
            }

            @Override
            public boolean hasNext() {
                return this.parent.nextIndex() < ByteSubList.this.to;
            }

            @Override
            public boolean hasPrevious() {
                return this.parent.previousIndex() >= ByteSubList.this.from;
            }

            @Override
            public byte nextByte() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.parent.nextByte();
            }

            @Override
            public byte previousByte() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                return this.parent.previousByte();
            }

            @Override
            public void add(byte k) {
                this.parent.add(k);
            }

            @Override
            public void set(byte k) {
                this.parent.set(k);
            }

            @Override
            public void remove() {
                this.parent.remove();
            }
        }
    }

    static final class IndexBasedSpliterator
    extends ByteSpliterators.LateBindingSizeIndexBasedSpliterator {
        final ByteList l;

        IndexBasedSpliterator(ByteList l, int pos) {
            super(pos);
            this.l = l;
        }

        IndexBasedSpliterator(ByteList l, int pos, int maxPos) {
            super(pos, maxPos);
            this.l = l;
        }

        @Override
        protected final int getMaxPosFromBackingStore() {
            return this.l.size();
        }

        @Override
        protected final byte get(int i) {
            return this.l.getByte(i);
        }

        @Override
        protected final IndexBasedSpliterator makeForSplit(int pos, int maxPos) {
            return new IndexBasedSpliterator(this.l, pos, maxPos);
        }
    }
}

