/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.QueryParam;
import java.util.Collections;
import java.util.List;

public class PaginationOptions {
    @Parameter(description="The index of the first entry to return starting at 0")
    @QueryParam(value="start")
    private int startIndex;
    @Parameter(description="Maximum number of entries to return. If set to 0 all entries will be omitted and only relevant metadata is returned. If set to a negative value, all relevant entries are returned.")
    @QueryParam(value="max")
    @DefaultValue(value="300")
    private int maxResults;

    public PaginationOptions() {
        this(0, -1);
    }

    @JsonCreator
    public PaginationOptions(@JsonProperty(value="start") int startIndex, @JsonProperty(value="max") int maxResults) {
        this.startIndex = startIndex;
        this.maxResults = maxResults;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public <T> List<T> applyFilter(List<T> results) {
        if (this.startIndex >= results.size()) {
            return Collections.emptyList();
        }
        if (this.maxResults < 0) {
            this.maxResults = results.size();
        }
        return results.subList(this.startIndex, Math.min(results.size(), this.startIndex + this.maxResults));
    }
}

