/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.abap;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.metadata.TokenElementMetadataIndex;
import com.teamscale.index.metadata.abap.AbapFileMetadata;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.Optional;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/abap-file-meta-data")
public class AbapFileMetadataService
extends ApiBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Retrieves metadata for an ABAP file stored in Teamscale, previously retrieved from some SAP system.", description="Retrieves metadata for an ABAP file stored in Teamscale, previously retrieved from some SAP System", tags={"SAP", "System"}, responses={@ApiResponse(responseCode="200", description="Returns the Metadata for given ABAP file."), @ApiResponse(responseCode="404", description="The given ABAP file is not found or no SAP system found for the Teamscale project.")})
    @Path(value="{filePath : .*}")
    public AbapFileMetadata getMetadataForFile(@Parameter(description="Path to the file in Teamscale.") @PathParam(value="filePath") String filePath, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor commit) throws StorageException {
        TokenElementMetadataIndex tokenElementMetadataIndex = this.openProjectIndex(TokenElementMetadataIndex.class, this.determineHistoryOption(commit));
        Optional result = tokenElementMetadataIndex.getMetadataOfTypeForFile(filePath, AbapFileMetadata.class);
        if (result.isEmpty()) {
            throw new NotFoundException("Metadata for " + filePath + " doesn't exist.");
        }
        return (AbapFileMetadata)result.get();
    }
}

