/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.admin.profiler;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.index.admin.profiler.ProcessInformation;
import com.teamscale.index.admin.profiler.ProfilerConfiguration;
import com.teamscale.index.admin.profiler.ProfilerInfo;
import com.teamscale.index.admin.profiler.ProfilerRegistration;
import com.teamscale.service.admin.profiler.ProfilerConfigurationsService;
import com.teamscale.service.admin.profiler.ProfilerLogEntry;
import com.teamscale.service.admin.profiler.RunningProfilersService;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresBasicPermission;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import java.util.List;
import java.util.UUID;
import org.conqat.engine.persistence.store.StorageException;

@Deprecated
@Path(value="api/running-profilers")
public class ProfilersLegacyService
extends ApiBase {
    @Context
    private ResourceContext resourceContext;

    @GET
    @RequiresNoPermission(description="No permissions needed, as the service will only return the profiler infos that use a profiler configuration that is visible to the current user.")
    @PublicApi(since=ETeamscaleVersion.VERSION_9_4_0, deprecatedSince=ETeamscaleVersion.VERSION_2024_8_0)
    @Operation(summary="Get profiler configuration", description="Retrieves the profiler configuration identified by given ID.", tags={"Profilers"}, responses={@ApiResponse(responseCode="404", description="No profiler config with given ID found.")})
    public ProfilerConfiguration getProfilerConfiguration(@Parameter(description="ID of the profiler configuration to retrieve.") @QueryParam(value="configuration-id") String configurationId) throws StorageException {
        this.getPermissions().checkBasicPermission(EBasicPermissionScope.PROFILER_CONFIGURATIONS, configurationId, EBasicPermission.VIEW);
        return ((ProfilerConfigurationsService)this.resourceContext.getResource(ProfilerConfigurationsService.class)).getProfilerConfiguration(configurationId);
    }

    @POST
    @Operation(summary="Push more logs of a running profiler", description="Push more logs of a running profiler", tags={"Profilers"})
    @RequiresNoPermission(description="No permissions needed, as the service will only return the profiler infos that use a profiler configuration that is visible to the current user.")
    @PublicApi(since=ETeamscaleVersion.VERSION_9_4_0, deprecatedSince=ETeamscaleVersion.VERSION_2024_8_0)
    @Path(value="{profilerId}/logs")
    public void postProfilerLog(@PathParam(value="profilerId") UUID profilerId, @RequestBody List<ProfilerLogEntry> entries) throws StorageException {
        ((RunningProfilersService)this.resourceContext.getResource(RunningProfilersService.class)).postProfilerLog(profilerId, entries);
    }

    @POST
    @PublicApi(since=ETeamscaleVersion.VERSION_9_4_0, deprecatedSince=ETeamscaleVersion.VERSION_2024_8_0)
    @RequiresBasicPermission(scope=EBasicPermissionScope.PROFILER_CONFIGURATIONS, permissions={EBasicPermission.VIEW}, entityQueryParameter="configuration-id")
    @Operation(summary="Registers a profiler instance", description="Registers a profiler to Teamscale and returns the profiler configuration it should be started with.", tags={"Profilers"})
    public ProfilerRegistration registerProfiler(@Parameter(description="The ID of the profiler configuration to retrieve.", required=true) @QueryParam(value="configuration-id") String configurationId, @RequestBody(required=true) ProcessInformation processInformation) throws StorageException {
        return ((RunningProfilersService)this.resourceContext.getResource(RunningProfilersService.class)).registerProfiler(configurationId, processInformation);
    }

    @PUT
    @Path(value="{profilerId}")
    @PublicApi(since=ETeamscaleVersion.VERSION_9_4_0, deprecatedSince=ETeamscaleVersion.VERSION_2024_8_0)
    @RequiresNoPermission(description="The user needs to have VIEW permissions on the configuration this profiler is using.")
    @Operation(summary="Profiler heartbeat", description="Updates the profiler infos and sets the profiler to still alive.", tags={"Profilers"})
    public void receiveHeartbeat(@Parameter(description="The ID of the profiler to update.", required=true) @PathParam(value="profilerId") UUID profilerId, @RequestBody(required=true) ProfilerInfo profilerInfo) throws StorageException {
        ((RunningProfilersService)this.resourceContext.getResource(RunningProfilersService.class)).receiveHeartbeat(profilerId, profilerInfo);
    }

    @DELETE
    @Path(value="{profilerId}")
    @PublicApi(since=ETeamscaleVersion.VERSION_9_4_0, deprecatedSince=ETeamscaleVersion.VERSION_2024_8_0)
    @RequiresNoPermission(description="The user needs to have VIEW permissions on the configuration this profiler is using.")
    @Operation(summary="Unregister profiler", description="Removes the profiler identified by given ID.", tags={"Profilers"})
    public void unregisterProfiler(@Parameter(description="The ID of the profiler to unregister.") @PathParam(value="profilerId") UUID profilerId) throws StorageException {
        ((RunningProfilersService)this.resourceContext.getResource(RunningProfilersService.class)).unregisterProfiler(profilerId);
    }
}

