/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.dashboard;

import com.teamscale.core.index.ProjectIndex;
import com.teamscale.index.dashboard.DashboardDescriptor;
import com.teamscale.index.dashboard.templates.DashboardTemplateDescriptor;
import com.teamscale.index.dashboard.templates.DashboardTemplateIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.dashboard.DashboardFromTemplateCreateServiceQueryOptions;
import com.teamscale.service.dashboard.DashboardService;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import java.util.Objects;
import java.util.UUID;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;

@Path(value="api/dashboards/from-template")
public class DashboardFromTemplateCreateService
extends ApiBase {
    @Context
    private ResourceContext resourceContext;

    @POST
    @RequiresNoPermission(description="Every logged in user is allowed to create dashboards")
    @Operation(summary="Create dashboard from template", description="Creates a dashboard from a template. Returns the ID of the created dashboard.", tags={"Dashboards"}, responses={@ApiResponse(responseCode="400", description="The dashboard already exists and the overwrite parameter is false."), @ApiResponse(responseCode="404", description="Dashboard template with provided ID not found")})
    @Produces(value={"application/json"})
    public UUID createDashboardFromTemplate(@BeanParam DashboardFromTemplateCreateServiceQueryOptions parameters) throws StorageException {
        DashboardTemplateIndex templateIndex = this.openGlobalIndex(DashboardTemplateIndex.class);
        return this.importTemplate(parameters, templateIndex);
    }

    private UUID importTemplate(DashboardFromTemplateCreateServiceQueryOptions parameters, DashboardTemplateIndex templateIndex) throws StorageException {
        UUID templateId = parameters.getTemplateId();
        DashboardTemplateDescriptor templateDescriptor = templateIndex.getDashboardTemplate(templateId);
        if (templateDescriptor == null) {
            throw new NotFoundException("No such dashboard template: " + String.valueOf(templateId));
        }
        DashboardDescriptor descriptor = new DashboardDescriptor();
        descriptor.name = parameters.getDashboardName();
        descriptor.comment = "Created from template '" + templateDescriptor.name + "'";
        this.setJsonString(parameters, templateDescriptor, descriptor);
        return ((DashboardService)this.resourceContext.getResource(DashboardService.class)).createDashboard(descriptor);
    }

    private void setJsonString(DashboardFromTemplateCreateServiceQueryOptions parameters, DashboardTemplateDescriptor templateDescriptor, DashboardDescriptor descriptor) throws StorageException {
        PublicProjectId projectId = parameters.getProjectId();
        String path = parameters.getPath();
        String projectName = this.openGlobalIndex(ProjectIndex.class).resolveProject((IProjectId)projectId).getName();
        String newDescriptor = templateDescriptor.getDescriptorAsJson().replaceAll("<PROJECT>", projectId.toString()).replaceAll("<PROJECT_NAME>", projectName);
        newDescriptor = newDescriptor.replaceAll("<PATH>", Objects.requireNonNullElse(path, ""));
        try {
            descriptor.setDescriptor(JsonUtils.deserializeFromJson((String)newDescriptor));
        }
        catch (JsonSerializationException e) {
            CCSMAssert.fail((String)("Template replacements should preserve validity of JSON: " + e.getMessage()));
        }
    }
}

