/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.dashboard;

import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.runtime.api.progress.EAnalysisState;
import com.teamscale.core.runtime.impl.progress.ProjectAnalysisProgressIndex;
import com.teamscale.core.runtime.impl.rollback.PostponedRollbackIndex;
import com.teamscale.index.repository.sap.abapsystem.AbapSystemDescription;
import com.teamscale.index.repository.status.ProjectConnectorStatus;
import com.teamscale.index.repository.status.ProjectConnectorStatusIndex;
import com.teamscale.service.project.PostponedRollbackCounts;
import com.teamscale.service.project.ProjectsConnectorState;
import com.teamscale.service.project.ProjectsState;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class ParallelProjectInfoLoadingUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MOST_RECENT_UPDATE_INTERVAL_HOURS = 30;

    public static ProjectsState getProjectsState(List<ProjectInfo> visibleProjects, IParallelTaskExecutor parallelTaskExecutor, IndexLayer indexLayer) throws ExecutionException, InterruptedException {
        Map<PublicProjectId, EAnalysisState> projectStates = ParallelProjectInfoLoadingUtils.getPerProjectInformation(visibleProjects, project -> ((ProjectAnalysisProgressIndex)indexLayer.openNonHistorizedProjectIndex(ProjectAnalysisProgressIndex.class, project)).getAnalysisState(), parallelTaskExecutor);
        return new ProjectsState(projectStates);
    }

    public static ProjectsConnectorState getProjectsConnectorState(List<ProjectInfo> visibleProjects, IParallelTaskExecutor parallelTaskExecutor, IndexLayer indexLayer) throws ExecutionException, InterruptedException {
        Map<PublicProjectId, ProjectConnectorStatus.EConnectorStatus> connectorStatuses = ParallelProjectInfoLoadingUtils.getPerProjectInformation(visibleProjects, project -> ParallelProjectInfoLoadingUtils.getAggregatedStatus(indexLayer, (ProjectConnectorStatusIndex)indexLayer.openNonHistorizedProjectIndex(ProjectConnectorStatusIndex.class, project), project), parallelTaskExecutor);
        return new ProjectsConnectorState(connectorStatuses);
    }

    public static PostponedRollbackCounts getPostponedRollbackCounts(List<ProjectInfo> visibleProjects, IParallelTaskExecutor parallelTaskExecutor, IndexLayer indexLayer) throws ExecutionException, InterruptedException {
        Map<PublicProjectId, Integer> counts = ParallelProjectInfoLoadingUtils.getPerProjectInformation(visibleProjects, project -> ((PostponedRollbackIndex)indexLayer.openNonHistorizedProjectIndex(PostponedRollbackIndex.class, project)).getEntryCount(), parallelTaskExecutor);
        return new PostponedRollbackCounts(counts);
    }

    private static <T> Map<PublicProjectId, T> getPerProjectInformation(List<ProjectInfo> visibleProjects, FunctionWithException<ProjectInfo, T, StorageException> informationExtractor, IParallelTaskExecutor parallelTaskExecutor) throws ExecutionException, InterruptedException {
        return (Map)parallelTaskExecutor.computeInParallel(visibleProjects, project -> ParallelProjectInfoLoadingUtils.getValuePerProject(informationExtractor, project), Collector.of(HashMap::new, Map::putAll, (m1, m2) -> {
            m1.putAll(m2);
            return m1;
        }, new Collector.Characteristics[0]));
    }

    private static <T> Map<PublicProjectId, T> getValuePerProject(FunctionWithException<ProjectInfo, T, StorageException> informationExtractor, ProjectInfo projectInfo) {
        HashMap<PublicProjectId, Object> projectStates = new HashMap<PublicProjectId, Object>();
        try {
            Object information = informationExtractor.apply((Object)projectInfo);
            for (PublicProjectId publicId : projectInfo.getPublicIds()) {
                projectStates.put(publicId, information);
            }
        }
        catch (StorageException e) {
            LOGGER.error("Failed to extract project information: " + e.getMessage(), (Throwable)e);
        }
        return projectStates;
    }

    private static ProjectConnectorStatus.EConnectorStatus getAggregatedStatus(IndexLayer indexLayer, ProjectConnectorStatusIndex connectorStatusIndex, ProjectInfo projectInfo) throws StorageException {
        List statuses = connectorStatusIndex.getAllStatuses();
        if (statuses.isEmpty()) {
            return ProjectConnectorStatus.EConnectorStatus.UNKNOWN;
        }
        if (ParallelProjectInfoLoadingUtils.projectUsesAbapConnector(indexLayer, projectInfo.getPrimaryPublicId())) {
            return ParallelProjectInfoLoadingUtils.getAggregatedStatusForAbapProject(statuses);
        }
        ProjectConnectorStatus.EConnectorStatus resultStatus = ProjectConnectorStatus.EConnectorStatus.HEALTHY;
        for (ProjectConnectorStatus status : statuses) {
            if (status.getStatus() == ProjectConnectorStatus.EConnectorStatus.ERROR) {
                return ProjectConnectorStatus.EConnectorStatus.ERROR;
            }
            if (status.getStatus() != ProjectConnectorStatus.EConnectorStatus.WARNING) continue;
            resultStatus = ProjectConnectorStatus.EConnectorStatus.WARNING;
        }
        return resultStatus;
    }

    private static boolean projectUsesAbapConnector(IndexLayer indexLayer, PublicProjectId publicProjectId) throws StorageException {
        ProjectConfiguration projectConfiguration = ProjectConfigurationUtils.getProjectConfiguration((IProjectId)publicProjectId, (IndexLayer)indexLayer);
        ServerOptionIndex serverOptionIndex = (ServerOptionIndex)indexLayer.openGlobalIndex(ServerOptionIndex.class);
        List sapSystemNames = CollectionUtils.map(AbapSystemDescription.getAllInstances((ServerOptionIndex)serverOptionIndex).keySet(), sapConnectionDescriptor -> StringUtils.getLastPart((String)sapConnectionDescriptor, (char)'/'));
        for (ConnectorConfiguration connectorConfiguration : projectConfiguration.getConnectors()) {
            if (!ERepositoryConnector.ABAP_GIT.getReadableName().equals(connectorConfiguration.getType()) && !ParallelProjectInfoLoadingUtils.projectUsesLegacyAbapGitConnector(connectorConfiguration, sapSystemNames)) continue;
            return true;
        }
        return false;
    }

    private static boolean projectUsesLegacyAbapGitConnector(ConnectorConfiguration connectorConfiguration, List<String> sapSystemNames) {
        String pathSuffix = connectorConfiguration.getOptionValue("Path suffix");
        for (String sapSystemName : sapSystemNames) {
            String pathSuffixFromSapSystem = sapSystemName + "/git";
            if (!pathSuffixFromSapSystem.equals(pathSuffix)) continue;
            return true;
        }
        return false;
    }

    private static ProjectConnectorStatus.EConnectorStatus getAggregatedStatusForAbapProject(List<ProjectConnectorStatus> statuses) {
        long timeWindowToCheckForRecentSAPUpdate = System.currentTimeMillis() - 108000000L;
        HashSet<ProjectConnectorStatus.EConnectorStatus> distinctStatuses = new HashSet<ProjectConnectorStatus.EConnectorStatus>();
        for (ProjectConnectorStatus status : statuses) {
            Long lastAttempt = status.getLastAttempt();
            if (lastAttempt == null || lastAttempt <= timeWindowToCheckForRecentSAPUpdate) continue;
            distinctStatuses.add(status.getStatus());
        }
        if (distinctStatuses.isEmpty()) {
            return ProjectConnectorStatus.EConnectorStatus.UNKNOWN;
        }
        if (distinctStatuses.contains(ProjectConnectorStatus.EConnectorStatus.ERROR)) {
            return ProjectConnectorStatus.EConnectorStatus.ERROR;
        }
        if (distinctStatuses.contains(ProjectConnectorStatus.EConnectorStatus.UNKNOWN)) {
            return ProjectConnectorStatus.EConnectorStatus.UNKNOWN;
        }
        return ProjectConnectorStatus.EConnectorStatus.HEALTHY;
    }

    private ParallelProjectInfoLoadingUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

