/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.documentation.layout;

import com.teamscale.service.documentation.layout.LayoutBase;
import java.util.Collections;
import java.util.List;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.string.StringUtils;

public class MarkdownLayout
extends LayoutBase {
    private static final String MARKDOWN_TABLE_HORIZONTAL_LINE = "---";
    private static final String MARKDOWN_NEW_PARAGRAPH = "\n\n";
    private static final String MARKDOWN_NEWLINE = "  \n";
    private static final String MARKDOWN_COLUMN_SEPARATOR = "|";
    private static final char MARKDOWN_HEADING = '#';
    private static final String MARKDOWN_BULLET = "*";
    private static final String MARKDOWN_ITALIC = "*";
    private static final String MARKDOWN_BOLD = "**";

    @Override
    public String newLine() {
        return MARKDOWN_NEWLINE;
    }

    @Override
    public String newParagraph() {
        return MARKDOWN_NEW_PARAGRAPH;
    }

    @Override
    public String colorize(String s, ETrafficLightColor color) {
        return "<span style=\"background-color:" + color.getHexValue() + "\">" + s + "</span>";
    }

    @Override
    public String escape(String s) {
        return s.replaceAll("(\\|`|\\*|\\{|\\}|\\[|\\]|\\(|\\)|#|\\+|-|\\.|!|_)", "\\\\$1");
    }

    @Override
    protected String makeHeading(String s, int level) {
        return StringUtils.fillString((int)level, (char)'#') + " " + s;
    }

    @Override
    public String startTable() {
        return "";
    }

    @Override
    public String tableHeader(String ... titles) {
        return StringUtils.concat((Object[])titles, (String)MARKDOWN_COLUMN_SEPARATOR) + MARKDOWN_NEWLINE;
    }

    @Override
    public String tableHorizontalLine(int numberOfCells) {
        List<String> list = Collections.nCopies(numberOfCells, MARKDOWN_TABLE_HORIZONTAL_LINE);
        return StringUtils.concat(list, (String)MARKDOWN_COLUMN_SEPARATOR) + MARKDOWN_NEWLINE;
    }

    @Override
    public String tableRow(String ... cells) {
        return StringUtils.concat((Object[])cells, (String)MARKDOWN_COLUMN_SEPARATOR) + MARKDOWN_NEWLINE;
    }

    @Override
    public String endTable() {
        return "";
    }

    @Override
    public String startBulletList() {
        return "";
    }

    @Override
    protected String makeBulletItem(String s, int level) {
        return StringUtils.fillString((int)((level - 1) * 4), (char)' ') + "* " + s;
    }

    @Override
    public String endBulletList() {
        return "";
    }

    @Override
    public String makeItalic(String s) {
        return "*" + s + "*";
    }

    @Override
    public String makeBold(String s) {
        return MARKDOWN_BOLD + s + MARKDOWN_BOLD;
    }

    @Override
    public String plainText(String s) {
        return s;
    }
}

