/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.jspecify.annotations.Nullable;

public class FindingBlacklistRequestBody {
    @JsonProperty(value="findingIds")
    private final List<String> findingIds;
    @JsonProperty(value="blacklistInfo")
    @Schema(requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    private final WrappedFindingBlacklistInfo wrappedInfo;
    @JsonProperty(value="autoApprove")
    @Schema(requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    private final boolean autoApprove;

    public FindingBlacklistRequestBody(List<String> findingIds, @Nullable String rationale, boolean autoApprove) {
        this.findingIds = new ArrayList<String>(findingIds);
        this.wrappedInfo = new WrappedFindingBlacklistInfo(Objects.requireNonNullElse(rationale, ""));
        this.autoApprove = autoApprove;
    }

    @JsonCreator
    static FindingBlacklistRequestBody fromJson(@JsonProperty(value="blacklistInfo") @Nullable WrappedFindingBlacklistInfo wrappedInfo, @JsonProperty(value="findingIds") List<String> findingIds, @JsonProperty(value="autoApprove") boolean autoApprove) {
        return new FindingBlacklistRequestBody(findingIds, Optional.ofNullable(wrappedInfo).map(WrappedFindingBlacklistInfo::rationale).orElse(null), autoApprove);
    }

    public UnmodifiableList<String> getFindingIds() {
        return CollectionUtils.asUnmodifiable(this.findingIds);
    }

    public String getRationale() {
        return this.wrappedInfo.rationale();
    }

    public boolean shouldAutoApprove() {
        return this.autoApprove;
    }

    private record WrappedFindingBlacklistInfo(@JsonProperty(value="rationale") @Nullable String rationale) {
    }
}

