/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.service.findings.FindingsIntroductionRemovalServiceBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;

public interface IFindingsServiceApi {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get finding", description="Retrieves a finding by its ID.", tags={"Findings"})
    @PublicApi(since=ETeamscaleVersion.VERSION_5_3_0)
    public TrackedFinding getFinding(@PathParam(value="id") String var1, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor var2) throws StorageException;

    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get finding with diff information", description="Retrieves a finding by its ID with additional information on when and where the finding was introduced or removed.", tags={"Findings"})
    @PublicApi(since=ETeamscaleVersion.VERSION_5_3_0)
    @Path(value="with-diff-info")
    public FindingsIntroductionRemovalServiceBase.TrackedFindingWithDiffInfo getFindingWithDiffInfo(@PathParam(value="id") String var1, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor var2) throws StorageException;

    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get sibling findings", description="Returns all sibling findings of the given finding. Only searches for siblings in the same findings partition. The finding with the given finding id is not included in the list.", tags={"Findings"})
    @Path(value="siblings")
    public List<TrackedFinding> getFindingSiblings(@PathParam(value="id") String var1, @QueryParam(value="t") UnresolvedCommitDescriptor var2) throws StorageException;
}

