/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings.refactoring;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.shallowparser.util.ShallowParsingUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.lib.commons.visitor.IMeshWalker;
import org.conqat.lib.commons.visitor.VisitorUtils;

public class Method {
    private final ShallowEntity entity;
    private final List<String> globalVariables;
    private final ControlFlowGraph controlFlowGraph;
    private Map<IToken, ControlFlowNode> tokenNodeMap;
    private int nestingDepth;
    private int nestingArea;

    public Method(ShallowEntity entity, List<String> globalVariables, ControlFlowGraph controlFlowGraph) {
        this.entity = entity;
        this.globalVariables = globalVariables;
        this.controlFlowGraph = controlFlowGraph;
        this.determineNestingDepthAndArea();
        this.fillTokenNodeMap();
    }

    private void determineNestingDepthAndArea() {
        this.nestingDepth = ShallowParsingUtils.getNestingDepth((List)this.entity.getChildrenOfType(EShallowEntityType.STATEMENT));
        this.nestingArea = ShallowParsingUtils.getNestingArea((List)this.entity.getChildrenOfType(EShallowEntityType.STATEMENT));
    }

    private void fillTokenNodeMap() {
        this.tokenNodeMap = new HashMap<IToken, ControlFlowNode>();
        ControlFlowNode mainControlFlowNode = this.controlFlowGraph.getRoot();
        List nodes = VisitorUtils.listAllDepthFirst((Object)mainControlFlowNode, (IMeshWalker)ControlFlowNode.DOWN_WALKER);
        for (ControlFlowNode node : nodes) {
            for (IToken token : node.getTokens()) {
                this.tokenNodeMap.put(token, node);
            }
        }
    }

    public ShallowEntity getEntity() {
        return this.entity;
    }

    protected List<String> getGlobalVariables() {
        return this.globalVariables;
    }

    public int getLength() {
        return ShallowEntityTraversalUtils.getAllEntities((Collection)this.entity.getChildren()).size();
    }

    public int getNumberOfInputParameters() {
        return this.controlFlowGraph.getRoot().getReadWriteInfo().getDefinitions().size();
    }

    public int getNestingArea() {
        return this.nestingArea;
    }

    public int getNestingDepth() {
        return this.nestingDepth;
    }

    public Map<IToken, ControlFlowNode> getTokenNodeMap() {
        return this.tokenNodeMap;
    }
}

