/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.merge_request;

import com.teamscale.index.merge_request.EMergeRequestStatus;
import com.teamscale.index.merge_request.ExtendedMergeRequest;
import com.teamscale.index.merge_request.ExtendedMergeRequestsInfo;
import com.teamscale.index.merge_request.MergeRequestsSummary;
import com.teamscale.service.merge_request.MergeRequestOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class MergeRequestFilterSortUtils {
    static ExtendedMergeRequestsInfo sortedFilteredMergeRequests(MergeRequestOptions mergeRequestOptions, List<ExtendedMergeRequest> extendedMergeRequests) {
        boolean hasOpen = MergeRequestFilterSortUtils.existMergeRequestStatus(extendedMergeRequests, EMergeRequestStatus.OPEN);
        boolean hasOther = MergeRequestFilterSortUtils.existMergeRequestStatus(extendedMergeRequests, EMergeRequestStatus.OTHER);
        extendedMergeRequests = MergeRequestFilterSortUtils.filterMergeRequestByStatus(extendedMergeRequests, mergeRequestOptions.getStatus());
        extendedMergeRequests = MergeRequestFilterSortUtils.filterMergeRequestByValue(extendedMergeRequests, mergeRequestOptions.getFilter());
        int total = extendedMergeRequests.size();
        MergeRequestsSummary mergeRequestsSummary = new MergeRequestsSummary(total, hasOpen, hasOther);
        extendedMergeRequests = mergeRequestOptions.getSortAndPaginationOptions().sortAndPaginate(extendedMergeRequests, ExtendedMergeRequest::getComparatorForField);
        return new ExtendedMergeRequestsInfo(extendedMergeRequests, mergeRequestsSummary);
    }

    private static List<ExtendedMergeRequest> filterMergeRequestByStatus(List<ExtendedMergeRequest> extendedMergeRequests, EMergeRequestStatus status) {
        return CollectionUtils.filter(extendedMergeRequests, extendedMergeRequest -> extendedMergeRequest.mergeRequest().status == status);
    }

    private static List<ExtendedMergeRequest> filterMergeRequestByValue(List<ExtendedMergeRequest> extendedMergeRequests, Pattern regex) {
        if (regex == null) {
            return extendedMergeRequests;
        }
        return CollectionUtils.filter(extendedMergeRequests, extendedMergeRequest -> MergeRequestFilterSortUtils.isIncluded(extendedMergeRequest, regex));
    }

    private static boolean existMergeRequestStatus(List<ExtendedMergeRequest> extendedMergeRequests, EMergeRequestStatus status) {
        return CollectionUtils.anyMatch(extendedMergeRequests, extendedMergeRequest -> extendedMergeRequest.mergeRequest().status == status);
    }

    private static boolean isIncluded(ExtendedMergeRequest extendedMergeRequest, Pattern pattern) {
        List<String> textsToMatch = MergeRequestFilterSortUtils.getTextsToMatchRegex(extendedMergeRequest);
        for (String textToMatch : textsToMatch) {
            if (!pattern.matcher(textToMatch).find()) continue;
            return true;
        }
        return false;
    }

    private static List<String> getTextsToMatchRegex(ExtendedMergeRequest extendedMergeRequest) {
        ArrayList<String> textsToMatch = new ArrayList<String>();
        textsToMatch.add(String.valueOf(extendedMergeRequest.mergeRequest().getId()));
        textsToMatch.add(extendedMergeRequest.mergeRequest().getTitle());
        textsToMatch.add(extendedMergeRequest.mergeRequest().getSourceBranch());
        textsToMatch.add(extendedMergeRequest.mergeRequest().getTargetBranch());
        textsToMatch.add(extendedMergeRequest.votingRecord().getState().toString());
        return textsToMatch;
    }

    private MergeRequestFilterSortUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

