/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.index.repository.retrievers.CommitMessagesRetrieverFactory;
import com.teamscale.index.repository.retrievers.ICommitMessagesRetriever;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.project.RepositoryPreviewServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.ProjectIdBase;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/commit-messages-retriever")
public class CommitMessagesRetrieverService
extends RepositoryPreviewServiceBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private String branchName;

    @POST
    @Operation(summary="Retrieves commit messages from VCSs", description="Returns latest commit messages for a given branch for a given VCS connector", responses={@ApiResponse(responseCode="400", description="Indicates problems with user input or project configuration.")})
    @RequiresNoPermission
    public Collection<String> previewRepositoryCommitMessages(@RequestBody ConnectorConfiguration connectorConfiguration, @Parameter(description="The name of the branch to fetch the commits from") @QueryParam(value="branchName") String branchName, @Parameter(description="The id of the project to which the connector configuration belongs") @QueryParam(value="projectId") PublicProjectId projectId) throws StorageException, RepositoryException, ServiceCallException {
        this.branchName = branchName;
        return this.previewValues(connectorConfiguration, projectId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Collection<String> retrieveValuesFromRepository(boolean projectExists, PublicProjectId projectId, ExternalCredentials credentials, ConnectorConfiguration connectorConfiguration) throws StorageException, RepositoryException, ProjectConfigurationException, ServiceCallException {
        String connectorType = connectorConfiguration.getType();
        ERepositoryConnector repositoryConnector = ERepositoryConnector.findByReadableName((String)connectorType);
        if (repositoryConnector == null) {
            throw new BadRequestException("Unsupported connector: " + connectorType);
        }
        ICommitMessagesRetriever commitMessagesRetriever = CommitMessagesRetrieverFactory.getCommitMessagesRetriever((ERepositoryConnector)repositoryConnector, (GlobalStorageSystem)this.getGlobalStorageSystem(), (Logger)LOGGER);
        String username = this.serviceInfo.getUser().getUsername();
        Lock repositoryLock = this.serviceInfo.getLockProvider().obtainLock(Optional.ofNullable(projectId).map(ProjectIdBase::toString).orElse(""));
        repositoryLock.lock();
        try {
            List list = commitMessagesRetriever.fetchCommitMessages(this.branchName, projectExists, username, credentials, connectorConfiguration);
            return list;
        }
        finally {
            repositoryLock.unlock();
        }
    }
}

