/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project;

import com.teamscale.core.option.project.ProjectOptionIndex;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.service.admin.ServerRenderedPageServiceBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

@Path(value="api/projects/{project}/options/repair")
public class ProjectOptionRepairService
extends ServerRenderedPageServiceBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @Hidden
    @Operation(summary="Repair project options", description="Provides an UI to run the project option repair operation. This should only be used for debugging and recovery operations.", tags={"Project", "Debugging"})
    @RequiresProjectPermission(value={EProjectPermission.EDIT})
    @Produces(value={"text/html"})
    public String getProjectOptionRepairPage() {
        return this.buildHttpFormPage();
    }

    @POST
    @Operation(summary="Repair project options", description="Restores project options that are orphaned after changing the project ID in the project configuration. This will overwrite current options with old ones, so has to be used with caution.", tags={"Project", "Debugging"})
    @RequiresProjectPermission(value={EProjectPermission.EDIT})
    public void repairProjectOptions() throws StorageException {
        ProjectOptionIndex projectOptionIndex = this.openProjectIndex(ProjectOptionIndex.class, null);
        List keys = projectOptionIndex.getAllOptionKeys();
        PairList values = new PairList();
        LOGGER.warn("Processing keys: " + String.valueOf(keys));
        ArrayList<String> keysToDelete = new ArrayList<String>();
        for (String key : keys) {
            int separatorIndex = key.indexOf(":");
            if (separatorIndex == -1) {
                LOGGER.error("Unexpected key format: " + key + ". Entry ignored.");
                continue;
            }
            InternalProjectId project = new InternalProjectId(key.substring(0, separatorIndex));
            String optionName = key.substring(separatorIndex + 1);
            if (project.equals((Object)this.serviceInfo.getInternalId())) continue;
            keysToDelete.add(key);
            values.add((Object)(String.valueOf(this.serviceInfo.getInternalId()) + ":" + optionName), (Object)projectOptionIndex.getOption(key));
        }
        projectOptionIndex.setOptions(values);
        projectOptionIndex.removeOptions(keysToDelete);
    }
}

