/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project.analysis_profile;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.AnalysisProfileIndex;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresBasicPermission;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.project.ConfigurationToolsService;
import eu.cqse.check.framework.scanner.ELanguage;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/config-languages")
public class ConfigurationLanguagesService
extends ApiBase {
    @GET
    @Path(value="{project}")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get configuration languages", description="Returns the languages available for analysis for a specific project, sorted by their readable name.", tags={"Project", "Analysis profiles"})
    public List<Language> getConfigLanguagesForProject(@PathParam(value="project") PublicProjectId projectId) throws StorageException {
        List analysisProfiles = AnalysisProfileUtils.getEmbeddedAnalysisProfiles((ProjectStorageSystem)this.getProjectStorageSystem((IProjectId)projectId));
        return ConfigurationLanguagesService.getLanguagesFromAnalysisProfiles(analysisProfiles);
    }

    @GET
    @Path(value="{project}/scopes")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get configuration languages and tools per scope", description="Returns the languages and tools available per code scope for analysis for a specific project", tags={"Project", "Analysis profiles"})
    public Map<CodeScopeName, LanguagesAndTools> getScopeAwareLanguagesAndTools(@PathParam(value="project") PublicProjectId projectId) throws StorageException, ProjectConfigurationException {
        MetaIndex projectMetaIndex = (MetaIndex)this.getProjectStorageSystem((IProjectId)projectId).openProjectIndex(MetaIndex.class, null);
        ProjectConfiguration projectConfiguration = (ProjectConfiguration)projectMetaIndex.getValue(ProjectConfiguration.class);
        CodeScopeAware analysisProfilePerScope = projectConfiguration.getAnalysisProfilePerScope(this.openGlobalIndex(AnalysisProfileIndex.class));
        HashMap<CodeScopeName, LanguagesAndTools> result = new HashMap<CodeScopeName, LanguagesAndTools>();
        analysisProfilePerScope.iterator().forEachRemaining(entry -> {
            List<AnalysisProfile> analysisProfiles = List.of((AnalysisProfile)entry.getValue());
            Set<ELanguage> languages = ConfigurationLanguagesService.getLanguagesFromAnalysisProfiles(analysisProfiles).stream().map(Language::getLanguage).collect(Collectors.toSet());
            Set<EAnalysisTool> tools = ConfigurationToolsService.getToolsFromAnalysisProfiles(analysisProfiles, languages);
            result.put((CodeScopeName)entry.getKey(), new LanguagesAndTools(languages, tools));
        });
        return result;
    }

    @GET
    @Path(value="analysis-profile/{analysisProfileName}")
    @RequiresBasicPermission(scope=EBasicPermissionScope.ANALYSIS_PROFILES, permissions={EBasicPermission.VIEW}, entityPathParameter="analysisProfileName")
    @Operation(summary="Get configuration languages", description="Returns the languages in the given analysis profile, sorted by their readable name.", tags={"Analysis profiles"})
    public List<Language> getConfigLanguagesForAnalysisProfile(@PathParam(value="analysisProfileName") String analysisProfileName) throws StorageException {
        AnalysisProfileIndex analysisProfileIndex = this.openGlobalIndex(AnalysisProfileIndex.class);
        AnalysisProfile analysisProfile = analysisProfileIndex.getProfile(analysisProfileName);
        return ConfigurationLanguagesService.getLanguagesFromAnalysisProfiles(List.of(analysisProfile));
    }

    private static List<Language> getLanguagesFromAnalysisProfiles(List<AnalysisProfile> analysisProfiles) {
        Set configuredLanguages = AnalysisProfileUtils.getConfiguredLanguages(analysisProfiles);
        return configuredLanguages.stream().map(Language::new).sorted().collect(Collectors.toList());
    }

    @GET
    @RequiresNoPermission(description="This is available to every authenticated user.")
    @Operation(summary="Get configuration languages", description="Returns the languages available for analysis, sorted by their readable name.", tags={"Analysis profiles"})
    public List<Language> getConfigLanguages() {
        ArrayList<Language> languages = new ArrayList<Language>();
        for (ELanguage language : AnalysisProfileUtils.getSupportedLanguages()) {
            languages.add(new Language(language));
        }
        Collections.sort(languages);
        return languages;
    }

    public static class Language
    implements Comparable<Language> {
        @JsonProperty(value="language")
        private final ELanguage language;
        @JsonProperty(value="name")
        private final String name;

        public Language(ELanguage language) {
            this.language = language;
            this.name = language.getReadableName();
        }

        @Override
        public int compareTo(Language other) {
            return this.name.compareTo(other.name);
        }

        public ELanguage getLanguage() {
            return this.language;
        }

        public String getName() {
            return this.name;
        }
    }

    public record LanguagesAndTools(Set<ELanguage> languages, Set<EAnalysisTool> tools) {
    }
}

