/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project.metric_thresholds;

import com.teamscale.core.analysis.configuration.index.MetricThresholdConfigurationIndex;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfiguration;
import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.index.configuration.MetricThresholdConfigurationUtils;
import com.teamscale.index.configuration.service.EMetricThresholdConfigurationVersion;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresBasicPermission;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.framework.util.ResponseUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="api/metric-thresholds")
public class MetricThresholdConfigurationImportExportService
extends ApiBase {
    private static final String MULTIPART_DATA_PARAMETER_NAME = "metric-threshold-configuration-data";

    @POST
    @Path(value="import")
    @RequiresNoPermission(description="The service will only allow to import metric threshold configurations for projects that are visible to current user.")
    @Operation(summary="Import metric threshold configuration", description="Import metric threshold configuration.")
    @Consumes(value={"multipart/form-data"})
    public void importMetricThresholdsConfiguration(@ArraySchema(schema=@Schema(type="string", format="binary")) @FormDataParam(value="metric-threshold-configuration-data") List<FormDataBodyPart> metricThresholdsData) throws MigrationException, StorageException {
        GlobalStorageSystem globalStorageSystem = this.getGlobalStorageSystem();
        MetricThresholdConfigurationIndex metricThresholdIndex = this.openGlobalIndex(MetricThresholdConfigurationIndex.class);
        for (FormDataBodyPart data : metricThresholdsData) {
            MetricThresholdConfigurationUtils.createMetricThresholdConfiguration((byte[])((byte[])data.getEntityAs(byte[].class)), (MetricThresholdConfigurationIndex)metricThresholdIndex, (ServicePermissions)this.getPermissions(), (boolean)true, (GlobalStorageSystem)globalStorageSystem);
        }
    }

    @GET
    @Path(value="{target}/export")
    @RequiresBasicPermission(permissions={EBasicPermission.VIEW}, scope=EBasicPermissionScope.METRIC_THRESHOLD_CONFIGURATIONS, entityPathParameter="target")
    @Operation(summary="Export metric threshold configuration", description="Export metric threshold configuration.")
    public Response exportMetricThresholdsConfiguration(@Parameter(description="Metric threshold configuration name.") @PathParam(value="target") String target) throws StorageException {
        String configName = StringUtils.stripSuffix((String)target, (String)".tsthresholds");
        MetricThresholdConfigurationIndex metricThresholdIndex = this.openGlobalIndex(MetricThresholdConfigurationIndex.class);
        MetricThresholdConfiguration metricThresholdConfiguration = metricThresholdIndex.getConfigurationWithoutLoadingBaseConfiguration(configName);
        if (metricThresholdConfiguration == null) {
            throw new BadRequestException("Metric threshold configuration '" + target + "' not found!");
        }
        return ResponseUtils.toFileDownload((Object)metricThresholdConfiguration, (Enum)EMetricThresholdConfigurationVersion.CURRENT_VERSION, (String)target);
    }
}

