/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.reports;

import com.teamscale.index.quality_report.QualityArtifactProfile;
import com.teamscale.index.quality_report.QualityReport;
import com.teamscale.index.quality_report.ReportSlideBase;
import com.teamscale.index.quality_report.slides.TitleSlide;
import com.teamscale.service.framework.ITeamscaleServiceInfo;
import com.teamscale.service.reports.QualityArtifactValidator;
import java.util.List;
import java.util.function.Function;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

public class QualityReportValidator
extends QualityArtifactValidator<QualityReport> {
    public QualityReportValidator(QualityReport qualityArtifact, ITeamscaleServiceInfo serviceInfo) {
        super(qualityArtifact, serviceInfo);
    }

    @Override
    protected List<String> validateArtifact(Function<IProjectId, ProjectStorageSystem> storageSystemAccessor) throws StorageException {
        if (((QualityReport)this.qualityArtifact).getSlides().isEmpty()) {
            this.addTitleSlideToReport((QualityReport)this.qualityArtifact);
        }
        return super.validateArtifact(storageSystemAccessor);
    }

    private void addTitleSlideToReport(QualityReport newReport) {
        TitleSlide titleSlide = new TitleSlide("id-0", newReport.getMetaInfo().getName(), QualityReportValidator.createDefaultSubtitles(newReport.getQualityArtifactProfile()));
        newReport.addSlide((ReportSlideBase)titleSlide);
    }

    private static String createDefaultSubtitles(QualityArtifactProfile profile) {
        boolean hasStartBaseline = profile.getBaselineWithType().getType() == QualityArtifactProfile.EQualityArtifactBaselineType.BASELINE;
        boolean hasEndBaseline = profile.getEndWithType().getType() == QualityArtifactProfile.EQualityArtifactBaselineType.BASELINE;
        StringBuilder subTitleBuilder = new StringBuilder();
        if (hasStartBaseline) {
            subTitleBuilder.append(String.valueOf(TitleSlide.ETitleSlidePlaceholders.START_BASELINE_NAME) + " (" + String.valueOf(TitleSlide.ETitleSlidePlaceholders.START_DATE) + ")");
        } else {
            subTitleBuilder.append(TitleSlide.ETitleSlidePlaceholders.START_DATE);
        }
        subTitleBuilder.append(" to ");
        if (hasEndBaseline) {
            subTitleBuilder.append(String.valueOf(TitleSlide.ETitleSlidePlaceholders.END_BASELINE_NAME) + " (" + String.valueOf(TitleSlide.ETitleSlidePlaceholders.END_DATE) + ")");
        } else {
            subTitleBuilder.append(TitleSlide.ETitleSlidePlaceholders.END_DATE);
        }
        subTitleBuilder.append("\nProject: ");
        subTitleBuilder.append(TitleSlide.ETitleSlidePlaceholders.PROJECT_NAME);
        return subTitleBuilder.toString();
    }
}

