/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.repository.tfs;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.rest.client.retry.HttpRequestRetryPolicy;
import com.teamscale.core.utils.ProjectUtils;
import com.teamscale.index.repository.tfs.TfsRepositoryUtils;
import com.teamscale.index.repository.tfs.client.IAzureDevOpsTfvcRestApi;
import com.teamscale.index.repository.tfs.client.TfsHttpConnection;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CaseInsensitiveStringSet;

@Path(value="api/projects/{project}/tfs/{repository}/debug")
public class TfsDebugService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get changes live from TFS server", description="Fetches and returns the changes at a specific revision from the TFS server.", tags={"Repositories"})
    public CaseInsensitiveStringSet getExistingPathsAtRevision(@PathParam(value="repository") String repositoryIdentifier, @QueryParam(value="paths") List<String> paths, @QueryParam(value="revision") String revision) throws StorageException, ServiceCallException {
        ProjectIndex projectIndex = this.openGlobalIndex(ProjectIndex.class);
        ProjectConfiguration projectConfiguration = ProjectUtils.retrieveProjectConfig((IProjectId)projectIndex.resolveToInternalId((IProjectId)this.serviceInfo.getInternalId()), (IndexLayer)this.getIndexLayer());
        CCSMAssert.isNotNull((Object)projectConfiguration);
        ConnectorConfiguration tfsConnector = projectConfiguration.getConnectorByIdentifier(repositoryIdentifier);
        if (tfsConnector == null || !tfsConnector.getType().equals(ERepositoryConnector.TFS.getReadableName())) {
            throw new ServiceCallException("Could not find TFS connector for " + repositoryIdentifier);
        }
        ExternalCredentials credentials = this.openGlobalIndex(ExternalCredentialsIndex.class).getExternalCredentials(Objects.requireNonNull(tfsConnector.getOptionValue("Account")));
        if (credentials == null) {
            throw new ServiceCallException("Invalid External Credentials for " + tfsConnector.getOptionValue("Account"));
        }
        TfsHttpConnection tfsHttpConnection = new TfsHttpConnection(credentials, HttpRequestRetryPolicy.SYSTEM_DEFAULT, LOGGER);
        IAzureDevOpsTfvcRestApi tfvcVersionControlRestClient = tfsHttpConnection.createAzureDevOpsTfvcRestClient();
        return TfsRepositoryUtils.getExistingPathsAtRevision(paths, (IAzureDevOpsTfvcRestApi)tfvcVersionControlRestClient, (String)revision);
    }
}

