/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.system.debug;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.backup.TemporaryFileIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.util.ResponseUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

@Path(value="api/system/debug/temporary-files")
public class DebugTemporaryFileIndexService
extends ApiBase {
    @GET
    @Operation(summary="Lists all stored temporary files", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public List<TemporaryFileIndex.TemporaryFileDescriptor> listTemporaryFiles() throws StorageException {
        return this.openGlobalIndex(TemporaryFileIndex.class).listFiles();
    }

    @GET
    @Path(value="{fileName}")
    @Operation(summary="Downloads the provided temporary file", tags={"Debugging"})
    @ApiResponse(responseCode="404", description="No temporary file found for the given name")
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Produces(value={"application/octet-stream"})
    public Response downloadTemporaryFile(@PathParam(value="fileName") String fileName) throws StorageException {
        TemporaryFileIndex fileIndex = this.openGlobalIndex(TemporaryFileIndex.class);
        DebugTemporaryFileIndexService.checkFileExists(fileName, fileIndex);
        StreamingOutput streamingOutput = output -> {
            try (InputStream in = fileIndex.readFile(fileName);){
                FileSystemUtils.copy((InputStream)in, (OutputStream)output);
            }
            catch (StorageException e) {
                throw new IOException(e);
            }
        };
        return ResponseUtils.getFileDownloadResponse((Object)streamingOutput, (MediaType)MediaType.APPLICATION_OCTET_STREAM_TYPE, (String)fileName);
    }

    @DELETE
    @Path(value="{fileName}")
    @Operation(summary="Deletes the provided temporary file", tags={"Debugging"})
    @ApiResponse(responseCode="404", description="No temporary file found for the given name")
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public void deleteTemporaryFile(@PathParam(value="fileName") String fileName) throws StorageException {
        TemporaryFileIndex fileIndex = this.openGlobalIndex(TemporaryFileIndex.class);
        DebugTemporaryFileIndexService.checkFileExists(fileName, fileIndex);
        fileIndex.deleteFile(fileName);
    }

    private static void checkFileExists(String fileName, TemporaryFileIndex fileIndex) throws StorageException {
        if (!fileIndex.fileExists(fileName)) {
            throw new NotFoundException("Unknown file: " + fileName);
        }
    }
}

