/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact.information_retrieval.scoring;

import com.teamscale.index.tests.information_retrieval.data.Term;
import com.teamscale.service.testimpact.information_retrieval.ITfIdfGroundTruth;
import com.teamscale.service.testimpact.information_retrieval.scoring.ScoringOperatorBase;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class BM25ScoringOperator
extends ScoringOperatorBase {
    private static final double K1 = 1.2;
    private static final double B = 0.75;

    BM25ScoringOperator(ITfIdfGroundTruth groundTruth, CounterSet<Term> changeRequestTerms, int calculateTopK) {
        super(groundTruth, changeRequestTerms, calculateTopK);
    }

    @Override
    public double scoreTestImplementation(UniformPath uniformPath, CounterSet<Term> changeQueryTerms, CounterSet<Term> testImplementationTerms) throws StorageException {
        double result = 0.0;
        for (Term term : changeQueryTerms.getKeys()) {
            int numberOfDocumentsContainingTerm = this.groundTruth.getNumberOfDocumentsContaining(term);
            double tf = testImplementationTerms.getValue((Object)term);
            double termContribution = this.idf(numberOfDocumentsContainingTerm) * (tf * 2.2) / (tf + 1.2 * (0.25 + 0.75 * (double)testImplementationTerms.getTotal() / this.groundTruth.getAverageDocumentLength()));
            this.storeTermContributions(term, termContribution);
            result += termContribution;
        }
        return result;
    }

    private double idf(int numberOfDocumentsContainingTerm) {
        return Math.log(((double)(this.groundTruth.totalNumberOfDocuments() - numberOfDocumentsContainingTerm) + 0.5) / ((double)numberOfDocumentsContainingTerm + 0.5) + 1.0);
    }
}

