/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.webhook;

import com.atlassian.jwt.core.reader.JwtIssuerSharedSecretService;
import com.atlassian.jwt.core.reader.JwtIssuerValidator;
import com.atlassian.jwt.core.reader.NimbusJwtReaderFactory;
import com.atlassian.jwt.exception.JwtIssuerLacksSharedSecretException;
import com.atlassian.jwt.exception.JwtParseException;
import com.atlassian.jwt.exception.JwtUnknownIssuerException;
import com.atlassian.jwt.exception.JwtVerificationException;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.options.BaseUrlOption;
import com.teamscale.index.repository.RepositoryUpdateUtils;
import com.teamscale.index.repository.git.bitbucket.cloud.BitbucketCloudChangeRetriever;
import com.teamscale.index.repository.git.bitbucket.cloud.BitbucketCloudInstallationIndex;
import com.teamscale.index.repository.git.bitbucket.cloud.BitbucketCloudMergeRequestUpdateTrigger;
import com.teamscale.index.repository.git.bitbucket.cloud.BitbucketCloudUtils;
import com.teamscale.index.repository.git.bitbucket.cloud.client.BitbucketCloudJwtValidator;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.webhook.BitbucketCloudPullRequestEvent;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.webhook.BitbucketCloudRepositoryPushEvent;
import com.teamscale.service.framework.authentication.RequiresNoLogin;
import com.teamscale.service.webhook.GitManagementPlatformWebhookServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/bitbucket-cloud/app")
public class BitbucketCloudRequestsService
extends GitManagementPlatformWebhookServiceBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String WEB_HOOK_PATH = "web-hook";
    private static final String INSTALLED_PATH = "installed";
    private static final String UNINSTALLED_PATH = "uninstalled";

    public BitbucketCloudRequestsService() {
        super(BitbucketCloudChangeRetriever.class);
    }

    @GET
    @Path(value="install")
    @Operation(summary="Handles the installation of the Bitbucket App.", description="Returns the Bitbucket app descriptor that is needed to successfully install the app on the Bitbucket server.", tags={"Voting Connectors"}, responses={@ApiResponse(responseCode="500", description="No base URL configured in Teamscale.")})
    @RequiresNoLogin
    public BitbucketAppDescriptor installBitbucketApp() throws StorageException {
        ServerOptionIndex serverOptionIndex = this.openGlobalIndex(ServerOptionIndex.class);
        String baseUrl = BaseUrlOption.getBaseUrl((ServerOptionIndex)serverOptionIndex);
        if (baseUrl == null) {
            throw new InternalServerErrorException("No base URL configured in Teamscale. Please correctly configure the base URL to successfully install the app.");
        }
        return new BitbucketAppDescriptor(baseUrl);
    }

    @POST
    @Path(value="installed")
    @Operation(summary="Installs the Bitbucket Cloud app.", description="Handles the incoming request from the Bitbucket cloud for installing the app and adds the installation in the index.", tags={"Voting Connectors"})
    @Consumes(value={"application/json"})
    @RequiresNoLogin
    public Response handleInstallationEvent(@RequestBody BitbucketCloudInstallationIndex.BitbucketInstallation installationPayload) throws ConQATException {
        BitbucketCloudInstallationIndex installationIndex = this.openGlobalIndex(BitbucketCloudInstallationIndex.class);
        installationIndex.addInstallation(installationPayload);
        return Response.ok().build();
    }

    @POST
    @Path(value="uninstalled")
    @Operation(summary="Un-installs the Bitbucket Cloud app.", description="Handles the incoming request from the Bitbucket cloud for un-installing the app and removes the installation from the index.", tags={"Voting Connectors"})
    @Consumes(value={"application/json"})
    @RequiresNoLogin
    public Response handleUninstallationEvent(@RequestBody BitbucketCloudInstallationIndex.BitbucketInstallation installationPayload) throws ConQATException {
        BitbucketCloudInstallationIndex installationIndex = this.openGlobalIndex(BitbucketCloudInstallationIndex.class);
        AccessTokenIndex accessTokenIndex = this.openGlobalIndex(AccessTokenIndex.class);
        installationIndex.removeInstallation(installationPayload);
        BitbucketCloudUtils.removeInstallationToken((AccessTokenIndex)accessTokenIndex, (String)installationPayload.getInstallationUsername(), (String)installationPayload.getClientKey());
        return Response.ok().build();
    }

    @POST
    @Path(value="web-hook")
    @Operation(summary="Handles the incoming requests from the Bitbucket Cloud web hooks.", description="Handles the incoming requests from the Bitbucket cloud web hooks and processes the request body depending on the event. The events which are handled by the service are 'repo:push', 'pullrequest:created', 'pullrequest:updated' and 'pullrequest:fulfilled'.", tags={"Voting Connectors"})
    @Consumes(value={"application/json"})
    @RequiresNoLogin
    public Response processWebHookEvent(@HeaderParam(value="X-Event-Key") String eventKey, @Context HttpHeaders headers, @RequestBody byte[] webhookEvent) throws ConQATException {
        try {
            String authHeader = headers.getHeaderString("Authorization");
            this.decodeAndVerifyJwtAuthorization(authHeader);
        }
        catch (BadRequestException e) {
            return Response.ok().build();
        }
        String webhookEventJson = StringUtils.bytesToString((byte[])webhookEvent);
        LOGGER.debug("Received a web hook request from Bitbucket cloud with event \"{}\" and payload: {}", (Object)eventKey, (Object)webhookEventJson);
        this.handleEvent(eventKey, webhookEventJson);
        return Response.ok().build();
    }

    private void handleEvent(String eventKey, String webhookEventJson) throws ConQATException {
        switch (eventKey) {
            case "repo:push": {
                this.handlePushEvent((BitbucketCloudRepositoryPushEvent)JsonUtils.deserializeFromJsonWithNullCheck((String)webhookEventJson, BitbucketCloudRepositoryPushEvent.class));
                break;
            }
            case "pullrequest:updated": 
            case "pullrequest:created": 
            case "pullrequest:fulfilled": {
                this.handlePullRequestEvent((BitbucketCloudPullRequestEvent)JsonUtils.deserializeFromJsonWithNullCheck((String)webhookEventJson, BitbucketCloudPullRequestEvent.class));
                break;
            }
            default: {
                LOGGER.info("Unsupported webhook event with key " + eventKey + " at Bitbucket Cloud webhook.");
            }
        }
    }

    private void handlePullRequestEvent(BitbucketCloudPullRequestEvent pullRequestEvent) throws ConQATException {
        BitbucketCloudPullRequestEvent.BitbucketCloudPullRequestEventPayload pullRequestPayload = pullRequestEvent.getPayload();
        if (pullRequestPayload.getPullRequest() == null) {
            throw new BadRequestException("Invalid request: Missing pull request information in webhook payload");
        }
        if (pullRequestPayload.getRepository().getWorkspace() == null) {
            throw new BadRequestException("Invalid request: Missing workspace information in webhook payload");
        }
        String repositoryName = pullRequestPayload.getRepository().getWorkspace().getUuid() + "/" + pullRequestPayload.getRepository().getUuid();
        this.scheduleMergeRequestUpdateTriggers(repositoryName, pullRequestPayload.getPullRequest().getId(), BitbucketCloudMergeRequestUpdateTrigger.class, null);
    }

    private void handlePushEvent(BitbucketCloudRepositoryPushEvent pushEvent) throws ConQATException {
        BitbucketCloudRepositoryPushEvent.BitbucketCloudRepositoryPushEventPayload pushPayload = pushEvent.getPayload();
        if (pushPayload.getRepository().getWorkspace() == null) {
            throw new BadRequestException("Invalid request: Missing workspace information in webhook payload");
        }
        String repositoryName = pushPayload.getRepository().getWorkspace().getUuid() + "/" + pushPayload.getRepository().getUuid();
        RepositoryUpdateUtils.extractAndScheduleAffectedTriggers((String)repositoryName, (IndexLayer)this.getIndexLayer(), null);
    }

    private void decodeAndVerifyJwtAuthorization(String authHeader) {
        if (authHeader == null) {
            throw new BadRequestException("Invalid request: Missing authorization header for query");
        }
        String[] authParts = authHeader.split(" ", 2);
        if (authParts.length < 2) {
            throw new BadRequestException("Invalid request: Invalid authorization header format for query");
        }
        if (!authParts[0].equals("JWT")) {
            throw new BadRequestException("Invalid request: Invalid authorization type for query");
        }
        try {
            BitbucketCloudInstallationIndex installationIndex = this.openGlobalIndex(BitbucketCloudInstallationIndex.class);
            BitbucketCloudJwtValidator validator = new BitbucketCloudJwtValidator(installationIndex);
            NimbusJwtReaderFactory jwtReaderFactory = new NimbusJwtReaderFactory((JwtIssuerValidator)validator, (JwtIssuerSharedSecretService)validator);
            jwtReaderFactory.getReader(authParts[1]).readAndVerify(authParts[1], new HashMap());
        }
        catch (JwtIssuerLacksSharedSecretException | JwtParseException | JwtUnknownIssuerException | JwtVerificationException | StorageException e) {
            throw new BadRequestException("JWT verification of query failed: " + e.getMessage(), e);
        }
    }

    public static final class BitbucketAppDescriptor {
        @JsonProperty(value="key")
        private final String key;
        @JsonProperty(value="name")
        private final String name;
        @JsonProperty(value="description")
        private final String description;
        @JsonProperty(value="baseUrl")
        private final String baseUrl;
        @JsonProperty(value="scopes")
        private final List<String> scopes;
        @JsonProperty(value="contexts")
        private final List<String> contexts;
        @JsonProperty(value="vendor")
        private final Vendor vendor;
        @JsonProperty(value="authentication")
        private final AOauth authentication;
        @JsonProperty(value="lifecycle")
        private final LifeCycle lifecycle;
        @JsonProperty(value="modules")
        private final Modules modules;

        @JsonCreator
        public BitbucketAppDescriptor(String baseUrl) {
            if (!((String)baseUrl).endsWith("/")) {
                baseUrl = (String)baseUrl + "/";
            }
            this.key = "teamscale-bitbucket-app";
            this.name = "Teamscale App";
            this.description = "This app shows a summary of the Teamscale Findings that a pull request introduces to the code base.";
            this.baseUrl = (String)baseUrl + "api/bitbucket-cloud/app";
            this.scopes = Arrays.asList("account", "issue", "pullrequest:write", "repository", "team");
            this.contexts = Collections.singletonList("account");
            this.vendor = new Vendor();
            this.authentication = new AOauth();
            this.lifecycle = new LifeCycle();
            this.modules = new Modules();
        }
    }

    private static final class Hook {
        @JsonProperty(value="event")
        private final String event;
        @JsonProperty(value="url")
        private final String url;

        @JsonCreator
        public Hook() {
            this.event = "*";
            this.url = "/web-hook";
        }
    }

    private static final class Modules {
        @JsonProperty(value="webhooks")
        private final List<Hook> webhooks = Collections.singletonList(new Hook());

        @JsonCreator
        public Modules() {
        }
    }

    private static final class LifeCycle {
        @JsonProperty(value="installed")
        private final String installed;
        @JsonProperty(value="uninstalled")
        private final String uninstalled;

        @JsonCreator
        public LifeCycle() {
            this.installed = "/installed";
            this.uninstalled = "/uninstalled";
        }
    }

    private static final class AOauth {
        @JsonProperty(value="type")
        private final String type;

        @JsonCreator
        public AOauth() {
            this.type = "jwt";
        }
    }

    private static final class Vendor {
        @JsonProperty(value="name")
        private final String name;
        @JsonProperty(value="url")
        private final String url;

        @JsonCreator
        public Vendor() {
            this.name = "CQSE GmbH";
            this.url = "https://cqse.eu";
        }
    }
}

