/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.base.string_interpolation;

import eu.cqse.check.base.string_interpolation.FormatStrategy;
import eu.cqse.check.base.string_interpolation.MessageFormatUtils;
import eu.cqse.check.base.string_interpolation.MethodCallFinding;
import eu.cqse.check.framework.scanner.IToken;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.jspecify.annotations.NonNull;

public class JavaFormatStrategies {
    private static final Pattern PRINTF_PATTERN = Pattern.compile("%(?<index>\\d+\\$)?(?<sign>[-#+ 0,(<]*)?(?<width>\\d+)?(?<precision>\\.\\d+)?([tT])?(?<letter>[a-zA-Z%])");
    private static final Pattern MESSAGE_PATTERN = Pattern.compile("\\{(?<index>\\d+)(?<type>,\\w+)?(?<style>,[^}]*)?}");
    public static final FormatStrategy LOG4J = (formatString, paramList, typeOfLastParameter) -> {
        if (MESSAGE_PATTERN.matcher(formatString).find()) {
            return new MessageFormatStrategy(true).handleCall(formatString, paramList, typeOfLastParameter);
        }
        if (PRINTF_PATTERN.matcher(formatString).find()) {
            return new PrintfFormatStrategy(true).handleCall(formatString, paramList, typeOfLastParameter);
        }
        return new ParameterizedFormatStrategy(true).handleCall(formatString, paramList, typeOfLastParameter);
    };

    private static void setImplicitThrowableParamAsUsed(boolean analyzingLogger, List<List<IToken>> paramList, Set<Integer> usedIndices, FormatStrategy.LastParameterType typeOfLastParameter) {
        if (analyzingLogger && (typeOfLastParameter == FormatStrategy.LastParameterType.UNKNOWN || typeOfLastParameter == FormatStrategy.LastParameterType.EXCEPTION) && !paramList.isEmpty()) {
            usedIndices.add(paramList.size() - 1);
        }
    }

    public static boolean looksLikeAFormatString(String text) {
        return MESSAGE_PATTERN.matcher(text).find() || PRINTF_PATTERN.matcher(text).find() || ParameterizedMessage.countArgumentPlaceholders((String)text) > 0;
    }

    public static class MessageFormatStrategy
    implements FormatStrategy {
        private final boolean analyzingLogger;

        public MessageFormatStrategy(boolean analyzingLogger) {
            this.analyzingLogger = analyzingLogger;
        }

        @Override
        public @NonNull List<MethodCallFinding> handleCall(String formatString, List<List<IToken>> paramList, FormatStrategy.LastParameterType typeOfLastParameter) {
            String messageFormatString = MessageFormatUtils.removeEscapedFromMessageFormatString(formatString);
            Matcher m = MESSAGE_PATTERN.matcher(messageFormatString);
            int maxIndex = -1;
            HashSet<Integer> usedIndices = new HashSet<Integer>();
            while (m.find()) {
                int usedIndex = Integer.parseInt(m.group(1));
                usedIndices.add(usedIndex + 1);
                maxIndex = Math.max(maxIndex, usedIndex);
            }
            ArrayList<MethodCallFinding> findings = new ArrayList<MethodCallFinding>(FormatStrategy.reportNotEnoughArgs(paramList, maxIndex + 1));
            JavaFormatStrategies.setImplicitThrowableParamAsUsed(this.analyzingLogger, paramList, usedIndices, typeOfLastParameter);
            findings.addAll(FormatStrategy.reportUnusedParameters(paramList, usedIndices, 1));
            return findings;
        }
    }

    public static class PrintfFormatStrategy
    implements FormatStrategy {
        private final boolean analyzingLogger;

        public PrintfFormatStrategy(boolean analyzingLogger) {
            this.analyzingLogger = analyzingLogger;
        }

        @Override
        public @NonNull List<MethodCallFinding> handleCall(String formatString, List<List<IToken>> paramList, FormatStrategy.LastParameterType typeOfLastParameter) {
            ArrayList<MethodCallFinding> findings = new ArrayList<MethodCallFinding>();
            Matcher m = PRINTF_PATTERN.matcher(formatString);
            int maxIndexUsedImplicitly = 0;
            int maxIndex = 0;
            boolean anySpecifiers = false;
            HashSet<Integer> usedIndices = new HashSet<Integer>();
            while (m.find()) {
                if (m.group("index") != null) {
                    String indexDollar = m.group("index");
                    int usedIndex = Integer.parseInt(indexDollar.substring(0, indexDollar.length() - 1));
                    usedIndices.add(usedIndex);
                    maxIndex = Math.max(maxIndex, usedIndex);
                    anySpecifiers = true;
                    continue;
                }
                if (m.group("sign") != null && m.group("sign").contains("<") && !anySpecifiers) {
                    findings.add(new MethodCallFinding.ParameterListIndexFinding("Backreference with <, but there is no first specifier", 0));
                }
                if (m.group("sign") != null && m.group("sign").contains("<") || m.group("letter").equals("n") || m.group("letter").equals("%")) continue;
                ++maxIndexUsedImplicitly;
                anySpecifiers = true;
            }
            int maxSpecifierIndex = Math.max(maxIndexUsedImplicitly, maxIndex);
            findings.addAll(FormatStrategy.reportNotEnoughArgs(paramList, maxSpecifierIndex));
            JavaFormatStrategies.setImplicitThrowableParamAsUsed(this.analyzingLogger, paramList, usedIndices, typeOfLastParameter);
            findings.addAll(FormatStrategy.reportUnusedParameters(paramList, usedIndices, maxIndexUsedImplicitly + 1));
            return findings;
        }
    }

    public static class ParameterizedFormatStrategy
    implements FormatStrategy {
        private final boolean analyzingLogger;

        public ParameterizedFormatStrategy(boolean analyzingLogger) {
            this.analyzingLogger = analyzingLogger;
        }

        @Override
        public @NonNull List<MethodCallFinding> handleCall(String formatString, List<List<IToken>> paramList, FormatStrategy.LastParameterType typeOfLastParameter) {
            int usageCount = ParameterizedMessage.countArgumentPlaceholders((String)formatString);
            Set<Integer> usedIndices = IntStream.range(1, usageCount + 1).boxed().collect(Collectors.toSet());
            ArrayList<MethodCallFinding> findings = new ArrayList<MethodCallFinding>(FormatStrategy.reportNotEnoughArgs(paramList, usageCount));
            JavaFormatStrategies.setImplicitThrowableParamAsUsed(this.analyzingLogger, paramList, usedIndices, typeOfLastParameter);
            findings.addAll(FormatStrategy.reportUnusedParameters(paramList, usedIndices, usageCount + 1));
            return findings;
        }
    }
}

