/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.typetracker;

import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.typetracker.ITypeInfoExtractor;
import eu.cqse.check.framework.typetracker.TypedVariable;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;

public abstract class TypeInfoExtractorBase
implements ITypeInfoExtractor {
    @Override
    public List<TypedVariable> extract(ShallowEntity entity) {
        switch (entity.getType()) {
            case MODULE: {
                return this.extractFromModule(entity);
            }
            case META: {
                return this.extractFromMeta(entity);
            }
            case TYPE: {
                return this.extractFromType(entity);
            }
            case ATTRIBUTE: {
                return this.extractFromAttribute(entity);
            }
            case METHOD: {
                return this.extractFromMethod(entity);
            }
            case STATEMENT: {
                return this.extractFromStatement(entity);
            }
        }
        CCSMAssert.fail((String)("Entities of type " + String.valueOf(entity.getType()) + " are currently not supported. If they should, this must be implemented in " + this.getClass().getName() + "."));
        return null;
    }

    public List<TypedVariable> extractFromModule(ShallowEntity moduleEntity) {
        return CollectionUtils.emptyList();
    }

    public List<TypedVariable> extractFromMeta(ShallowEntity metaEntity) {
        return CollectionUtils.emptyList();
    }

    public List<TypedVariable> extractFromType(ShallowEntity typeEntity) {
        return CollectionUtils.emptyList();
    }

    public List<TypedVariable> extractFromAttribute(ShallowEntity attributeEntity) {
        return CollectionUtils.emptyList();
    }

    public List<TypedVariable> extractFromMethod(ShallowEntity methodEntity) {
        return CollectionUtils.emptyList();
    }

    public List<TypedVariable> extractFromStatement(ShallowEntity statementEntity) {
        return CollectionUtils.emptyList();
    }
}

