/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util;

import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.util.AbapLanguageFeatureParser;
import eu.cqse.check.framework.util.CppLanguageFeatureParser;
import eu.cqse.check.framework.util.CsLanguageFeatureParser;
import eu.cqse.check.framework.util.ILanguageFeatureParser;
import eu.cqse.check.framework.util.JavaLanguageFeatureParser;
import eu.cqse.check.framework.util.JavaScriptLanguageFeatureParser;
import eu.cqse.check.framework.util.MatlabLanguageFeatureParser;
import eu.cqse.check.framework.util.ObjectiveCLanguageFeatureParser;
import eu.cqse.check.framework.util.ObjectiveCppLanguageFeatureParser;
import eu.cqse.check.framework.util.PythonLanguageFeatureParser;
import java.util.Optional;

public final class LanguageFeatureParser {
    public static final AbapLanguageFeatureParser ABAP = new AbapLanguageFeatureParser();
    public static final CppLanguageFeatureParser CPP = CppLanguageFeatureParser.createParser(true);
    public static final CppLanguageFeatureParser C = CppLanguageFeatureParser.createParser(false);
    public static final CsLanguageFeatureParser CS = new CsLanguageFeatureParser();
    public static final JavaLanguageFeatureParser JAVA = new JavaLanguageFeatureParser();
    public static final MatlabLanguageFeatureParser MATLAB = new MatlabLanguageFeatureParser();
    public static final PythonLanguageFeatureParser PYTHON = new PythonLanguageFeatureParser();
    public static final ObjectiveCLanguageFeatureParser OBJECTIVE_C = new ObjectiveCLanguageFeatureParser();
    public static final ObjectiveCppLanguageFeatureParser OBJECTIVE_CPP = new ObjectiveCppLanguageFeatureParser();
    public static final JavaScriptLanguageFeatureParser JAVASCRIPT = new JavaScriptLanguageFeatureParser();

    public static Optional<ILanguageFeatureParser> getInstance(ELanguage language) {
        return Optional.ofNullable(switch (language) {
            case ELanguage.ABAP -> ABAP;
            case ELanguage.CPP -> CPP;
            case ELanguage.C -> C;
            case ELanguage.CS -> CS;
            case ELanguage.JAVA -> JAVA;
            case ELanguage.MATLAB -> MATLAB;
            case ELanguage.PYTHON -> PYTHON;
            case ELanguage.OBJECTIVE_C -> OBJECTIVE_C;
            case ELanguage.OBJECTIVE_CPP -> OBJECTIVE_CPP;
            case ELanguage.JAVASCRIPT -> JAVASCRIPT;
            default -> null;
        });
    }
}

