/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.provider;

import com.teamscale.service.framework.impl.provider.FunctionalConverter;
import com.teamscale.service.framework.impl.provider.InvalidValueException;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.string.StringUtils;

@Provider
public class PublicProjectIdConverterProvider
implements ParamConverterProvider {
    public <P> ParamConverter<P> getConverter(Class<P> rawType, Type genericType, Annotation[] annotations) {
        if (rawType.isAssignableFrom(PublicProjectId.class) && !rawType.isInterface()) {
            return new FunctionalConverter(annotations, PublicProjectIdConverterProvider::convert);
        }
        return null;
    }

    private static PublicProjectId convert(String projectId) throws InvalidValueException {
        if (StringUtils.isEmpty((String)projectId)) {
            return null;
        }
        try {
            return new PublicProjectId(projectId);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidValueException(e.getMessage(), e);
        }
    }
}

