/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.visualstudio.services.account.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.alm.client.HttpMethod;
import com.microsoft.alm.client.VssHttpClientBase;
import com.microsoft.alm.client.VssRestClientHandler;
import com.microsoft.alm.client.VssRestRequest;
import com.microsoft.alm.client.model.NameValueCollection;
import com.microsoft.alm.visualstudio.services.account.Account;
import com.microsoft.alm.visualstudio.services.account.AccountNameAvailability;
import com.microsoft.alm.visualstudio.services.account.AccountRegion;
import com.microsoft.alm.visualstudio.services.account.client.AccountCreateInfoInternal;
import com.microsoft.alm.visualstudio.services.webapi.ApiResourceVersion;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public abstract class AccountHttpClientBase
extends VssHttpClientBase {
    private static final Map<String, Class<? extends Exception>> TRANSLATED_EXCEPTIONS = new HashMap<String, Class<? extends Exception>>();

    protected AccountHttpClientBase(VssRestClientHandler clientHandler, URI baseUrl) {
        super(clientHandler, baseUrl);
    }

    @Override
    protected Map<String, Class<? extends Exception>> getTranslatedExceptions() {
        return TRANSLATED_EXCEPTIONS;
    }

    public UUID deleteAccount(UUID accountId) {
        UUID locationId = UUID.fromString("6468322a-cb4d-43a3-84ad-be573301bbb3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("accountId", accountId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, UUID.class);
    }

    public Account createAccount(AccountCreateInfoInternal info, Boolean usePrecreated) {
        UUID locationId = UUID.fromString("229a6a53-b428-4ffb-a835-e8f36b5b4b1e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("usePrecreated", usePrecreated);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, apiVersion, info, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, Account.class);
    }

    public Account getAccount(String accountId, String properties) {
        UUID locationId = UUID.fromString("229a6a53-b428-4ffb-a835-e8f36b5b4b1e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("accountId", accountId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("properties", properties);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, Account.class);
    }

    public ArrayList<Account> getAccounts(UUID creatorId, UUID ownerId, UUID memberId, Boolean includeOwner, String properties, Boolean includeDisabledAccounts) {
        UUID locationId = UUID.fromString("229a6a53-b428-4ffb-a835-e8f36b5b4b1e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("creatorId", creatorId);
        queryParameters.addIfNotNull("ownerId", ownerId);
        queryParameters.addIfNotNull("memberId", memberId);
        queryParameters.addIfNotNull("includeOwner", includeOwner);
        queryParameters.addIfNotEmpty("properties", properties);
        queryParameters.addIfNotNull("includeDisabledAccounts", includeDisabledAccounts);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Account>>(){});
    }

    public void updateAccount(Account account, UUID accountId) {
        UUID locationId = UUID.fromString("229a6a53-b428-4ffb-a835-e8f36b5b4b1e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("accountId", accountId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, account, "application/json", "application/json");
        super.sendRequest(httpRequest);
    }

    public AccountNameAvailability isValidAccountName(String accountName) {
        UUID locationId = UUID.fromString("65dd1dc5-53fe-4c67-9b4e-0ec3e2539998");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("accountName", accountName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, AccountNameAvailability.class);
    }

    public ArrayList<AccountRegion> getRegions() {
        UUID locationId = UUID.fromString("642a93c7-8385-4d63-a5a5-20d044fe504f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<AccountRegion>>(){});
    }

    public HashMap<String, String> getAccountSettings() {
        UUID locationId = UUID.fromString("4e012dd4-f8e1-485d-9bb3-c50d83c5b71b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<HashMap<String, String>>(){});
    }
}

