/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.framework.configuration.internal;

import com.microsoft.tfs.core.TFSConfigurationServer;
import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.framework.configuration.TFSEntitySession;
import com.microsoft.tfs.core.clients.framework.configuration.internal.TFSCatalogEntitySession;
import com.microsoft.tfs.core.clients.framework.configuration.internal.TFSCompatibilityEntitySession;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TFSEntitySessionFactory {
    private static final Log log = LogFactory.getLog(TFSEntitySessionFactory.class);

    public static TFSEntitySession newEntitySession(TFSConfigurationServer connection) {
        Check.notNull(connection, "connection");
        return new TFSCatalogEntitySession(connection);
    }

    public static TFSEntitySession newEntitySession(TFSTeamProjectCollection connection) {
        Check.notNull(connection, "connection");
        if (connection.getConfigurationServer() != null) {
            log.info((Object)MessageFormat.format("Creating catalog-based configuration entity session for {0}", connection.getName()));
            return new TFSCatalogEntitySession(connection.getConfigurationServer());
        }
        log.info((Object)MessageFormat.format("Creating compatibility configuration entity session for {0}", connection.getName()));
        return new TFSCompatibilityEntitySession(connection);
    }
}

