/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol;

import com.microsoft.tfs.core.clients.versioncontrol.BranchHistory;
import com.microsoft.tfs.core.clients.versioncontrol.BranchHistoryTreeItem;
import com.microsoft.tfs.core.clients.versioncontrol.GetItemsOptions;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.DeletedState;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Item;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemSet;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.VersionSpec;
import com.microsoft.tfs.core.util.Hierarchical;
import com.microsoft.tfs.util.Check;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BranchHistoryUtil {
    public static void updateServerItems(Workspace workspace, VersionSpec versionSpec, BranchHistory branchHistory) {
        Check.notNull(workspace, "workspace");
        Check.notNull(versionSpec, "versionSpec");
        Check.notNull(branchHistory, "branchHistory");
        Map<String, Item> versionMap = BranchHistoryUtil.createVersionMap(workspace, versionSpec, branchHistory);
        BranchHistoryUtil.updateServerItems(versionMap, branchHistory);
    }

    private static Map<String, Item> createVersionMap(Workspace workspace, VersionSpec versionSpec, BranchHistory branchHistory) {
        HashMap<String, Item> latestVersionMap = new HashMap<String, Item>();
        Set<ItemSpec> itemSpecSet = BranchHistoryUtil.collectServerItems(branchHistory);
        ItemSpec[] itemSpecs = itemSpecSet.toArray(new ItemSpec[itemSpecSet.size()]);
        if (itemSpecs.length > 0) {
            ItemSet[] items = workspace.getClient().getItems(itemSpecs, versionSpec, DeletedState.ANY, ItemType.ANY, GetItemsOptions.INCLUDE_SOURCE_RENAMES);
            for (int i = 0; i < items.length; ++i) {
                Item[] branchItems = items[i].getItems();
                for (int j = 0; j < branchItems.length; ++j) {
                    latestVersionMap.put(branchItems[j].getServerItem(), branchItems[j]);
                }
            }
        }
        return latestVersionMap;
    }

    private static Set<ItemSpec> collectServerItems(Hierarchical branchHistoryItem) {
        BranchHistoryTreeItem treeItem;
        HashSet<ItemSpec> serverItems = new HashSet<ItemSpec>();
        if (branchHistoryItem instanceof BranchHistoryTreeItem && !(branchHistoryItem instanceof BranchHistory) && (treeItem = (BranchHistoryTreeItem)branchHistoryItem).getItem() != null) {
            serverItems.add(new ItemSpec(treeItem.getItem().getServerItem(), RecursionType.NONE));
        }
        Object[] children = branchHistoryItem.getChildren();
        for (int i = 0; i < children.length; ++i) {
            serverItems.addAll(BranchHistoryUtil.collectServerItems((Hierarchical)children[i]));
        }
        return serverItems;
    }

    private static void updateServerItems(Map<String, Item> versionItems, Hierarchical branchHistoryItem) {
        String serverItem;
        Item updatedItem;
        Object[] children = branchHistoryItem.getChildren();
        for (int i = 0; i < children.length; ++i) {
            BranchHistoryUtil.updateServerItems(versionItems, (Hierarchical)children[i]);
        }
        if (branchHistoryItem instanceof BranchHistory) {
            return;
        }
        BranchHistoryTreeItem treeItem = (BranchHistoryTreeItem)branchHistoryItem;
        if (treeItem.getItem() != null && (updatedItem = versionItems.get(serverItem = treeItem.getItem().getServerItem())) != null) {
            treeItem.setItem(updatedItem);
        }
    }
}

