/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.localworkspace;

import com.microsoft.tfs.core.clients.versioncontrol.localworkspace.IgnoreEntry;
import com.microsoft.tfs.core.clients.versioncontrol.localworkspace.LocalItemExclusionEvaluator;
import com.microsoft.tfs.core.clients.versioncontrol.path.ItemPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.util.CodePageMapping;
import com.microsoft.tfs.core.util.FileEncoding;
import com.microsoft.tfs.core.util.FileEncodingDetector;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.IOUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IgnoreFile {
    private static final Log log = LogFactory.getLog(IgnoreFile.class);
    private static final char c_includePrefix = '!';
    private static final char c_commentPrefix = '#';
    private final String m_directory;
    private final List<IgnoreEntry> m_ignoreEntries = new ArrayList<IgnoreEntry>();

    public IgnoreFile(String directory) {
        this.m_directory = directory;
    }

    public void addEntry(IgnoreEntry ignoreEntry) {
        this.m_ignoreEntries.add(ignoreEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IgnoreFile load(String directory) {
        IgnoreFile toReturn;
        block9: {
            Check.notNull(directory, "directory");
            toReturn = null;
            try {
                BufferedReader streamReader;
                block10: {
                    String fileName = new File(directory, LocalItemExclusionEvaluator.IGNORE_FILE_NAME).getAbsolutePath();
                    if (!new File(fileName).exists()) break block9;
                    toReturn = new IgnoreFile(directory);
                    FileEncoding tfsEncoding = FileEncodingDetector.detectEncoding(fileName, FileEncoding.AUTOMATICALLY_DETECT);
                    Charset charset = CodePageMapping.getCharset(tfsEncoding.getCodePage(), false);
                    if (charset == null) {
                        charset = CodePageMapping.getCharset(FileEncoding.getDefaultTextEncoding().getCodePage());
                    }
                    FileInputStream fileStream = null;
                    streamReader = null;
                    try {
                        String line;
                        fileStream = new FileInputStream(fileName);
                        streamReader = new BufferedReader(new InputStreamReader((InputStream)fileStream, charset.name()));
                        while (null != (line = streamReader.readLine())) {
                            IgnoreFile.addExcludeEntry(directory, toReturn, line);
                        }
                        if (fileStream == null) break block10;
                    }
                    catch (Throwable throwable) {
                        if (fileStream != null) {
                            IOUtils.closeSafely(fileStream);
                        }
                        if (streamReader != null) {
                            IOUtils.closeSafely(streamReader);
                        }
                        throw throwable;
                    }
                    IOUtils.closeSafely(fileStream);
                }
                if (streamReader != null) {
                    IOUtils.closeSafely(streamReader);
                }
            }
            catch (Exception ex) {
                log.warn((Object)"Error loading ignore file", (Throwable)ex);
                return null;
            }
        }
        return toReturn;
    }

    public static IgnoreFile load(String directory, String[] ignorePatterns) {
        Check.notNull(directory, "directory");
        Check.notNull(ignorePatterns, "ignorePatterns");
        IgnoreFile toReturn = null;
        toReturn = new IgnoreFile(directory);
        for (String pattern : ignorePatterns) {
            IgnoreFile.addExcludeEntry(directory, toReturn, pattern);
        }
        return toReturn;
    }

    private static void addExcludeEntry(String directory, IgnoreFile toReturn, String pattern) {
        try {
            if (pattern.length() > 0 && (pattern.charAt(0) == '\ufeff' || pattern.charAt(0) == '\ufffe')) {
                pattern = pattern.substring(1);
            }
            if ((pattern = pattern.trim()).length() > 0) {
                if (pattern.charAt(0) == '#' || pattern.charAt(0) == '\ufeff' && pattern.length() > 1 && pattern.charAt(1) == '#') {
                    return;
                }
                pattern = pattern.replace("/", File.separator);
                pattern = pattern.replace("\\", File.separator);
                boolean isExcluded = true;
                boolean isRecursive = true;
                boolean isFolderOnly = false;
                if (pattern.charAt(0) == '!' && pattern.length() > 1) {
                    isExcluded = false;
                    pattern = pattern.substring(1);
                }
                if (pattern.charAt(0) == File.separatorChar && pattern.length() > 1) {
                    isRecursive = false;
                    pattern = pattern.substring(1);
                }
                if (pattern.charAt(pattern.length() - 1) == File.separatorChar && pattern.length() > 1) {
                    isFolderOnly = true;
                    pattern = pattern.substring(0, pattern.length() - 1);
                }
                if ((pattern = pattern.trim()).length() > 0) {
                    toReturn.addEntry(new IgnoreEntry(LocalPath.combine(directory, pattern), isExcluded, isRecursive, isFolderOnly));
                }
            }
        }
        catch (Exception ex) {
            log.warn((Object)"Error parsing ignore file line", (Throwable)ex);
        }
    }

    public Boolean isExcluded(String path, boolean isFolder, String startPath, AtomicReference<String> exclusion) {
        Check.notNullOrEmpty(path, "path");
        Check.notNullOrEmpty(startPath, "startPath");
        if (exclusion != null) {
            exclusion.set(null);
        }
        Boolean toReturn = null;
        block0: for (IgnoreEntry ignoreEntry : this.m_ignoreEntries) {
            int i = startPath.length();
            if (startPath.charAt(startPath.length() - 1) != File.separatorChar) {
                ++i;
            }
            int k = Integer.MAX_VALUE;
            if (null != ignoreEntry.path) {
                if (!LocalPath.isChild(ignoreEntry.path, path)) continue;
                k = ignoreEntry.path.length();
                if (ignoreEntry.path.charAt(ignoreEntry.path.length() - 1) != File.separatorChar) {
                    ++k;
                }
                i = Math.max(i, k);
            }
            while (i >= 0 && i < path.length() && (ignoreEntry.isRecursive || i <= k)) {
                int j = path.indexOf(File.separatorChar, i);
                if (j < 0) {
                    j = path.length();
                }
                if (ignoreEntry.isFolderOnly && !isFolder && j == path.length()) continue block0;
                j -= i;
                boolean match = false;
                if (ignoreEntry.isEndsWith) {
                    if (ignoreEntry.pattern.length() <= j && 0 == this.compareCaseInsensitive(path, i + j - ignoreEntry.pattern.length(), ignoreEntry.pattern, 0, ignoreEntry.pattern.length())) {
                        match = true;
                    }
                } else if (ignoreEntry.isStartsWith) {
                    if (ignoreEntry.pattern.length() <= j && 0 == this.compareCaseInsensitive(path, i, ignoreEntry.pattern, 0, ignoreEntry.pattern.length())) {
                        match = true;
                    }
                } else if (ignoreEntry.isComplex) {
                    if (ItemPath.matchesWildcardFile(path.substring(i, i + j), ignoreEntry.pattern)) {
                        match = true;
                    }
                } else if (ignoreEntry.pattern.length() == j && 0 == this.compareCaseInsensitive(path, i, ignoreEntry.pattern, 0, ignoreEntry.pattern.length())) {
                    match = true;
                }
                if (match) {
                    if (ignoreEntry.isExcluded) {
                        toReturn = true;
                        if (exclusion != null) {
                            exclusion.set(ignoreEntry.originalExclusion);
                        }
                    } else if (i + j == path.length()) {
                        toReturn = false;
                        if (exclusion != null) {
                            exclusion.set(ignoreEntry.originalExclusion);
                        }
                    }
                }
                i += j + 1;
            }
        }
        return toReturn;
    }

    public String getDirectory() {
        return this.m_directory;
    }

    public String getFullPath() {
        if (this.m_directory == null || this.m_directory.length() == 0) {
            return "";
        }
        return new File(this.m_directory, LocalItemExclusionEvaluator.IGNORE_FILE_NAME).getAbsolutePath();
    }

    private int compareCaseInsensitive(String strA, int offsetA, String strB, int offsetB, int length) {
        if (strA == null && strB != null) {
            return -1;
        }
        if (strA != null && strB == null) {
            return 1;
        }
        if ((strA == null || strB == null) && length > 0) {
            throw new IndexOutOfBoundsException("length cannot be > 0 with null string arguments");
        }
        int endA = offsetA + length;
        int endB = offsetB + length;
        if (endA > strA.length()) {
            throw new IndexOutOfBoundsException("offsetA + length is past the end of strA");
        }
        if (endB > strB.length()) {
            throw new IndexOutOfBoundsException("offsetB + length is past the end of strB");
        }
        int iA = offsetA;
        int iB = offsetB;
        while (iA < endA) {
            char b;
            char a = strA.charAt(iA);
            if (a != (b = strB.charAt(iB)) && (a = Character.toUpperCase(a)) != (b = Character.toUpperCase(b)) && (a = Character.toLowerCase(a)) != (b = Character.toLowerCase(b))) {
                return a - b;
            }
            ++iA;
            ++iB;
        }
        return 0;
    }
}

