/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.soapextensions;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.internal.wrappers.EnumerationWrapper;
import com.microsoft.tfs.util.Check;
import java.util.HashMap;
import ms.tfs.versioncontrol.clientservices._03._ItemType;

public class ItemType
extends EnumerationWrapper {
    public static final HashMap<Byte, ItemType> VALUE_MAP = new HashMap();
    public static final ItemType ANY = new ItemType(_ItemType.Any, 0);
    public static final ItemType FOLDER = new ItemType(_ItemType.Folder, 1);
    public static final ItemType FILE = new ItemType(_ItemType.File, 2);
    private final byte value;

    private ItemType(_ItemType itemType, byte value) {
        super(itemType);
        this.value = value;
        Byte key = new Byte(value);
        Check.isTrue(!VALUE_MAP.containsKey(key), "duplicate key");
        VALUE_MAP.put(key, this);
    }

    public static ItemType fromByteValue(byte value) {
        Byte key = new Byte(value);
        Check.isTrue(VALUE_MAP.containsKey(key), "value");
        return VALUE_MAP.get(key);
    }

    public static ItemType fromWebServiceObject(_ItemType webServiceObject) {
        return (ItemType)EnumerationWrapper.fromWebServiceObject(webServiceObject);
    }

    public _ItemType getWebServiceObject() {
        return (_ItemType)this.webServiceObject;
    }

    public byte getValue() {
        return this.value;
    }

    public String toUIString() {
        if (this == FILE) {
            return Messages.getString("ItemType.File");
        }
        if (this == FOLDER) {
            return Messages.getString("ItemType.Folder");
        }
        return "";
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

