/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.workspacecache.internal;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.MappingConflictException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.MultipleWorkspacesFoundException;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.InternalWorkspaceConflictInfo;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.LocalWorkspaceState;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.WorkspaceInfo;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.internal.InternalServerInfo;
import com.microsoft.tfs.core.util.URIUtils;
import com.microsoft.tfs.jni.helpers.LocalHost;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import com.microsoft.tfs.util.xml.DOMUtils;
import com.microsoft.tfs.util.xml.XMLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class InternalCache {
    private static final String XML_SERVER_INFO = "ServerInfo";
    private static final String XML_URI = "uri";
    private static final String XML_GUID = "repositoryGuid";
    private final Object workstationMutex;
    private final List<WorkspaceInfo> activeWorkspaces;
    private final List<WorkspaceInfo> removedWorkspaces;
    private boolean urlChanged;

    public InternalCache(Object workstationMutex) {
        Check.notNull(workstationMutex, "workstationMutex");
        this.workstationMutex = workstationMutex;
        this.activeWorkspaces = new ArrayList<WorkspaceInfo>();
        this.removedWorkspaces = new ArrayList<WorkspaceInfo>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalServerInfo getServerInfoByGUID(GUID guid, URI uri) {
        InternalServerInfo serverInfo = null;
        Object object = this.workstationMutex;
        synchronized (object) {
            for (WorkspaceInfo workspace : this.activeWorkspaces) {
                if (!workspace.getServer().getServerGUID().equals(guid) || Workspace.matchServerURI(workspace.getServer().getURI(), uri)) continue;
                workspace.getServer().setURI(uri);
                serverInfo = workspace.getServer();
                break;
            }
        }
        if (serverInfo == null) {
            serverInfo = new InternalServerInfo(uri, guid);
        }
        return serverInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalServerInfo getServerInfoByURI(URI uri) {
        InternalServerInfo serverInfo = null;
        Object object = this.workstationMutex;
        synchronized (object) {
            for (WorkspaceInfo workspace : this.activeWorkspaces) {
                if (!Workspace.matchServerURI(workspace.getServer().getURI(), uri)) continue;
                serverInfo = workspace.getServer();
                break;
            }
        }
        return serverInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForMappingConflicts(Workspace workspaceToCheck, Workspace workspaceToIgnore) {
        Object object = this.workstationMutex;
        synchronized (object) {
            WorkspaceInfo wiToCheck = new WorkspaceInfo(this.getServerInfoByGUID(workspaceToCheck.getServerGUID(), workspaceToCheck.getClient().getConnection().getBaseURI()), workspaceToCheck);
            WorkspaceInfo wiToIgnore = null;
            if (null != workspaceToIgnore) {
                wiToIgnore = new WorkspaceInfo(this.getServerInfoByGUID(workspaceToIgnore.getServerGUID(), workspaceToIgnore.getClient().getConnection().getBaseURI()), workspaceToIgnore);
            }
            this.checkForMappingConflicts(wiToCheck, wiToIgnore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForMappingConflicts(WorkspaceInfo workspaceToCheck, WorkspaceInfo workspaceToIgnore) throws MappingConflictException {
        for (String newMap : workspaceToCheck.getMappedPaths()) {
            Object object = this.workstationMutex;
            synchronized (object) {
                String conflictingMap = this.getMapping(newMap, workspaceToIgnore);
                if (conflictingMap != null) {
                    throw new MappingConflictException(MessageFormat.format(Messages.getString("InternalCache.ConflictingWorkingFoldersFormat"), newMap, this.formatWorkspaceNameForException(workspaceToCheck, this.getWorkspace(conflictingMap))));
                }
                for (WorkspaceInfo existingWS : this.activeWorkspaces) {
                    if (null != workspaceToIgnore && existingWS.equals(workspaceToIgnore)) continue;
                    for (String existingMap : existingWS.getMappedPaths()) {
                        if (!LocalPath.isChild(newMap, existingMap)) continue;
                        throw new MappingConflictException(MessageFormat.format(Messages.getString("InternalCache.ConflictingWorkingFoldersFormat"), existingMap, this.formatWorkspaceNameForException(workspaceToCheck, this.getWorkspace(existingMap))));
                    }
                }
            }
        }
    }

    private InternalWorkspaceConflictInfo[] removeConflictingWorkspaces(WorkspaceInfo workspace) {
        HashSet<InternalWorkspaceConflictInfo> removedWorkspaces = new HashSet<InternalWorkspaceConflictInfo>();
        for (String newMap : workspace.getMappedPaths()) {
            String conflictingMap = this.getMapping(newMap);
            if (conflictingMap != null) {
                WorkspaceInfo wi = this.getWorkspace(conflictingMap);
                removedWorkspaces.add(new InternalWorkspaceConflictInfo(workspace, wi, conflictingMap));
                this.removeWorkspace(wi);
            }
            ArrayList<String> invalidWorkspacePaths = new ArrayList<String>();
            block1: for (WorkspaceInfo existingWS : this.activeWorkspaces) {
                for (String existingMap : existingWS.getMappedPaths()) {
                    if (!LocalPath.isChild(newMap, existingMap)) continue;
                    invalidWorkspacePaths.add(existingMap);
                    continue block1;
                }
            }
            for (String invalidWorkspacePath : invalidWorkspacePaths) {
                WorkspaceInfo wi = this.getWorkspace(invalidWorkspacePath);
                removedWorkspaces.add(new InternalWorkspaceConflictInfo(workspace, wi, invalidWorkspacePath));
                this.removeWorkspace(wi);
            }
        }
        return removedWorkspaces.toArray(new InternalWorkspaceConflictInfo[removedWorkspaces.size()]);
    }

    private String formatWorkspaceNameForException(WorkspaceInfo workspace, WorkspaceInfo conflictingWorkspace) {
        return workspace.formatWorkspaceNameForException(conflictingWorkspace);
    }

    public String getMapping(String path) {
        return this.getMapping(path, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMapping(String path, WorkspaceInfo workspaceToIgnore) {
        Object object = this.workstationMutex;
        synchronized (object) {
            for (WorkspaceInfo ws : this.activeWorkspaces) {
                String mappingFound;
                if (null != workspaceToIgnore && ws.equals(workspaceToIgnore) || null == (mappingFound = ws.getMapping(path))) continue;
                return mappingFound;
            }
        }
        return null;
    }

    public String getInheritedMapping(String path) {
        String mapping = this.getMapping(path);
        if (mapping == null) {
            return null;
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getMappingsRecursively(String path) {
        ArrayList<String> list = new ArrayList<String>();
        Object object = this.workstationMutex;
        synchronized (object) {
            for (WorkspaceInfo ws : this.activeWorkspaces) {
                for (String map : ws.getMappedPaths()) {
                    if (!LocalPath.isChild(path, map)) continue;
                    list.add(map);
                }
            }
        }
        return list.toArray(new String[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkspaceInfo getWorkspace(String path) {
        Object object = this.workstationMutex;
        synchronized (object) {
            for (WorkspaceInfo ws : this.activeWorkspaces) {
                if (ws.getMapping(path) == null) continue;
                return ws;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkspaceInfo getWorkspace(GUID repositoryGuid, String name, String owner) {
        Check.isTrue(!".".equals(owner), "owner must not be VersionControlConstants.AUTHENTICATED_USER");
        ArrayList<WorkspaceInfo> matchingWorkspaces = new ArrayList<WorkspaceInfo>();
        Object object = this.workstationMutex;
        synchronized (object) {
            for (WorkspaceInfo ws : this.activeWorkspaces) {
                if (!repositoryGuid.equals(ws.getServerGUID()) || !Workspace.matchName(name, ws.getName()) || !ws.ownerNameMatches(owner)) continue;
                matchingWorkspaces.add(ws);
            }
        }
        if (matchingWorkspaces.size() == 0) {
            return null;
        }
        if (matchingWorkspaces.size() > 1) {
            ArrayList<String> specs = new ArrayList<String>(matchingWorkspaces.size());
            for (WorkspaceInfo wsInfo : matchingWorkspaces) {
                specs.add(wsInfo.getQualifiedName());
            }
            throw new MultipleWorkspacesFoundException(name, owner, specs);
        }
        return (WorkspaceInfo)matchingWorkspaces.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkspaceInfo[] getAllWorkspaces() {
        Object object = this.workstationMutex;
        synchronized (object) {
            return this.activeWorkspaces.toArray(new WorkspaceInfo[this.activeWorkspaces.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Element config) {
        InternalCache newCache = InternalCache.load(config, true);
        Object object = this.workstationMutex;
        synchronized (object) {
            this.urlChanged = false;
            this.activeWorkspaces.clear();
            this.removedWorkspaces.clear();
            this.activeWorkspaces.addAll(newCache.activeWorkspaces);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InternalCache load(Element config, Object workstationMutex) {
        Check.notNull(config, "config");
        Check.notNull(workstationMutex, "workstationMutex");
        InternalCache newCache = new InternalCache(workstationMutex);
        for (Element serverNode : DOMUtils.getChildElements(config)) {
            URI serverUri;
            Node guidAttr = serverNode.getAttributes().getNamedItem(XML_GUID);
            GUID guid = new GUID(guidAttr.getNodeValue());
            Node serverUriAttr = serverNode.getAttributes().getNamedItem(XML_URI);
            try {
                serverUri = new URI(serverUriAttr.getNodeValue());
            }
            catch (URISyntaxException e) {
                throw new XMLException(Messages.getString("InternalCache.CouldNotReadServerURI"), e);
            }
            InternalServerInfo serverInfo = new InternalServerInfo(serverUri, guid);
            for (Element workspaceNode : DOMUtils.getChildElements(serverNode)) {
                WorkspaceInfo workspace = WorkspaceInfo.loadFromXML(serverInfo, workspaceNode);
                if (newCache.getWorkspace(serverInfo.getServerGUID(), workspace.getName(), workspace.getOwnerName()) != null) continue;
                Object object = workstationMutex;
                synchronized (object) {
                    newCache.activeWorkspaces.add(workspace);
                }
            }
        }
        Object object = workstationMutex;
        synchronized (object) {
            newCache.urlChanged = false;
        }
        return newCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Element inputXml, Element outputXml, AtomicReference<InternalWorkspaceConflictInfo[]> removedConflictingWorkspaces) {
        Object object = this.workstationMutex;
        synchronized (object) {
            removedConflictingWorkspaces.set(InternalWorkspaceConflictInfo.EMPTY_ARRAY);
            if (inputXml != null) {
                this.merge(inputXml, removedConflictingWorkspaces);
            }
            if (this.activeWorkspaces.size() == 0) {
                return;
            }
            Collections.sort(this.activeWorkspaces);
            InternalServerInfo lastServer = null;
            Element serverNode = null;
            for (WorkspaceInfo ws : this.activeWorkspaces) {
                if (lastServer == null || !ws.getServerGUID().equals(lastServer.getServerGUID())) {
                    serverNode = this.addRepositoryXMLNode(outputXml, ws.getServer());
                    lastServer = ws.getServer();
                }
                ws.saveAsXML(serverNode);
            }
        }
    }

    private Element addRepositoryXMLNode(Element outputXml, InternalServerInfo server) {
        Element serverNode = DOMUtils.appendChild(outputXml, XML_SERVER_INFO);
        serverNode.setAttribute(XML_URI, URIUtils.removeTrailingSlash(server.getURI()).toString());
        serverNode.setAttribute(XML_GUID, server.getServerGUID().toString());
        return serverNode;
    }

    public WorkspaceInfo insertWorkspace(Workspace workspace, AtomicReference<InternalWorkspaceConflictInfo[]> removedConflictingWorkspaces) {
        InternalServerInfo serverInfo = this.getServerInfoByGUID(workspace.getServerGUID(), workspace.getClient().getConnection().getBaseURI());
        return this.insertWorkspace(new WorkspaceInfo(serverInfo, workspace), removedConflictingWorkspaces);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkspaceInfo insertWorkspace(WorkspaceInfo workspace, AtomicReference<InternalWorkspaceConflictInfo[]> removedConflictingWorkspaces) {
        Check.isTrue(Workspace.matchComputer(workspace.getComputer(), LocalHost.getShortName()), MessageFormat.format("Workspace is on a different computer: {0}", workspace.getName()));
        Check.isTrue(!".".equals(workspace.getOwnerName()), "workspace.OwnerName must not be VersionControlConstants.AUTHENTICATED_USER");
        Object object = this.workstationMutex;
        synchronized (object) {
            this.checkRedundantWorkspaceName(workspace.getServer(), workspace.getName(), workspace.getOwnerName());
            removedConflictingWorkspaces.set(this.removeConflictingWorkspaces(workspace));
            this.activeWorkspaces.add(workspace);
        }
        return workspace;
    }

    private void checkRedundantWorkspaceName(InternalServerInfo server, String name, String ownerUniqueName) {
        WorkspaceInfo ws = this.getWorkspace(server.getServerGUID(), name, ownerUniqueName);
        Check.isTrue(ws == null, MessageFormat.format("There is already a workspace with the same repository, owner, and name: \n Original{0} Requested: {1} name: {2} owner: {3}", ws, server.getServerGUID(), name, ownerUniqueName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWorkspace(WorkspaceInfo workspace) {
        Object object = this.workstationMutex;
        synchronized (object) {
            WorkspaceInfo ws = this.getWorkspace(workspace.getServerGUID(), workspace.getName(), workspace.getOwnerName());
            Check.notNull(ws, MessageFormat.format("workspace: {0}", workspace.getName()));
            this.activeWorkspaces.remove(ws);
            ws.setState(LocalWorkspaceState.REMOVED);
            this.removedWorkspaces.add(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markClean() {
        Object object = this.workstationMutex;
        synchronized (object) {
            this.urlChanged = false;
            for (WorkspaceInfo ws : this.activeWorkspaces) {
                ws.markClean();
            }
            this.removedWorkspaces.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(Element xmlOnDisk, AtomicReference<InternalWorkspaceConflictInfo[]> removedConflictingWorkspaces) {
        InternalCache cacheOnDisk = InternalCache.load(xmlOnDisk, false);
        HashSet<InternalWorkspaceConflictInfo> removedWorkspacesSet = new HashSet<InternalWorkspaceConflictInfo>();
        Object object = this.workstationMutex;
        synchronized (object) {
            for (WorkspaceInfo ws : this.removedWorkspaces) {
                WorkspaceInfo wsToRemove = cacheOnDisk.getWorkspace(ws.getServerGUID(), ws.getName(), ws.getOwnerName());
                if (wsToRemove == null) continue;
                cacheOnDisk.removeWorkspace(wsToRemove);
            }
            for (int i = 0; i < this.activeWorkspaces.size(); ++i) {
                WorkspaceInfo ws;
                ws = this.activeWorkspaces.get(i);
                if (ws.getState() != LocalWorkspaceState.CLEAN || cacheOnDisk.getWorkspace(ws.getServerGUID(), ws.getName(), ws.getOwnerName()) != null) continue;
                this.activeWorkspaces.remove(ws);
                --i;
            }
            for (WorkspaceInfo ws : this.activeWorkspaces) {
                WorkspaceInfo newerWs;
                if (ws.getState() != LocalWorkspaceState.CLEAN || (newerWs = cacheOnDisk.getWorkspace(ws.getServerGUID(), ws.getName(), ws.getOwnerName())) == null) continue;
                ws.update(newerWs, true);
            }
            for (WorkspaceInfo ws : cacheOnDisk.activeWorkspaces) {
                if (this.getWorkspace(ws.getServerGUID(), ws.getName(), ws.getOwnerName()) != null) continue;
                try {
                    AtomicReference<InternalWorkspaceConflictInfo[]> removedWorkspaces = new AtomicReference<InternalWorkspaceConflictInfo[]>();
                    this.insertWorkspace(ws, removedWorkspaces);
                    for (InternalWorkspaceConflictInfo wi : removedWorkspaces.get()) {
                        removedWorkspacesSet.add(wi);
                    }
                }
                catch (MappingConflictException e) {
                    // empty catch block
                }
                Check.isTrue(ws.getState() == LocalWorkspaceState.CLEAN, "State is not clean: " + ws.getState());
            }
        }
        removedConflictingWorkspaces.set(removedWorkspacesSet.toArray(new InternalWorkspaceConflictInfo[removedWorkspacesSet.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateServerURI(GUID repositoryGuid, URI uri) {
        Object object = this.workstationMutex;
        synchronized (object) {
            for (WorkspaceInfo workspaceInfo : this.activeWorkspaces) {
                if (!workspaceInfo.getServerGUID().equals(repositoryGuid) || Workspace.matchServerURI(uri, workspaceInfo.getServerURI())) continue;
                workspaceInfo.getServer().setURI(uri);
                this.urlChanged = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWorkspaceCount() {
        Object object = this.workstationMutex;
        synchronized (object) {
            return this.activeWorkspaces.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirty() {
        Object object = this.workstationMutex;
        synchronized (object) {
            if (this.urlChanged) {
                return true;
            }
            if (this.removedWorkspaces.size() > 0) {
                return true;
            }
            for (WorkspaceInfo ws : this.activeWorkspaces) {
                if (ws.getState() == LocalWorkspaceState.CLEAN) continue;
                return true;
            }
        }
        return false;
    }
}

