/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.files;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.workitem.exceptions.UnableToSaveException;
import com.microsoft.tfs.core.clients.workitem.files.Attachment;
import com.microsoft.tfs.core.clients.workitem.files.DownloadException;
import com.microsoft.tfs.core.clients.workitem.files.LocalFileStatus;
import com.microsoft.tfs.core.clients.workitem.files.WorkItemAttachmentUtils;
import com.microsoft.tfs.core.clients.workitem.internal.InternalWorkItemUtils;
import com.microsoft.tfs.core.clients.workitem.internal.files.AttachmentUpDownHelper;
import com.microsoft.tfs.core.clients.workitem.internal.links.WITComponent;
import com.microsoft.tfs.util.xml.DOMUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.w3c.dom.Element;

public class AttachmentImpl
extends WITComponent
implements Attachment {
    private static final String URL_FILE_ID_PARAMETER_NAME = "FileID";
    private static final String URL_FILE_NAME_PARAMETER_NAME = "FileName";
    private static final String URL_ENCODING = "UTF-8";
    private final Date attachmentAddedDate;
    private final Date fileCreatedDate;
    private final Date fileLastModifiedDate;
    private final String comment;
    private final long fileSize;
    private final String fileName;
    private String serverGuid;
    private File localFile;

    public AttachmentImpl(File localFile, String comment) {
        super(true);
        LocalFileStatus status = WorkItemAttachmentUtils.validateLocalFileForUpload(localFile);
        if (status != LocalFileStatus.VALID) {
            throw new IllegalArgumentException(status.getErrorMessage(localFile, null));
        }
        this.validateTextMaxLength(comment, "comment", 255);
        this.localFile = localFile;
        this.comment = comment;
        this.attachmentAddedDate = new Date();
        this.fileCreatedDate = this.fileLastModifiedDate = new Date(localFile.lastModified());
        this.fileName = localFile.getName();
        this.fileSize = localFile.length();
    }

    public AttachmentImpl(Date attachmentAddedDate, Date fileCreatedDate, Date fileLastModifiedDate, String fileName, String comment, int fileSize, int id) {
        super(false);
        this.attachmentAddedDate = attachmentAddedDate;
        this.fileCreatedDate = fileCreatedDate;
        this.fileLastModifiedDate = fileLastModifiedDate;
        this.fileName = fileName;
        this.comment = comment;
        this.fileSize = fileSize;
        this.setExtID(id);
    }

    @Override
    public int getFileID() {
        return this.getExtID();
    }

    @Override
    public String getFileSizeAsString() {
        DecimalFormat decimalFormat = new DecimalFormat("#,###");
        long bytes = this.getFileSize();
        if (bytes == 0L) {
            return Messages.getString("FileAttachmentImpl.ZeroKilobytes");
        }
        if (bytes < 1000L) {
            return Messages.getString("FileAttachmentImpl.OneKilobyte");
        }
        float kb = (float)bytes / 1000.0f;
        return MessageFormat.format(Messages.getString("FileAttachmentImpl.CountKiloBytesFormat"), decimalFormat.format(Math.floor(kb)));
    }

    @Override
    public File getLocalFile() {
        return this.localFile;
    }

    @Override
    public URL getURL() {
        if (this.isNewlyCreated()) {
            try {
                return this.localFile.toURL();
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        }
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getAssociatedCollection().getWorkItemInternal().getContext().getAttachmentServerURL());
            buffer.append("?");
            buffer.append(URL_FILE_ID_PARAMETER_NAME);
            buffer.append("=");
            buffer.append(this.getExtID());
            buffer.append("&");
            buffer.append(URL_FILE_NAME_PARAMETER_NAME);
            buffer.append("=");
            buffer.append(URLEncoder.encode(this.fileName, URL_ENCODING));
            return new URL(buffer.toString());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Date getAttachmentAddedDate() {
        return this.attachmentAddedDate;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public Date getCreatedDate() {
        return this.fileCreatedDate;
    }

    @Override
    public Date getLastModifiedDate() {
        return this.fileLastModifiedDate;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public long getFileSize() {
        return this.fileSize;
    }

    @Override
    public void downloadTo(File target) throws DownloadException {
        if (target == null) {
            throw new IllegalArgumentException("target must be non-null");
        }
        if (this.isNewlyCreated()) {
            throw new IllegalStateException("you cannot call downloadTo on newly created attachments");
        }
        TFSTeamProjectCollection connection = this.getAssociatedCollection().getWorkItemInternal().getConnection();
        AttachmentUpDownHelper.download(this.getURL(), target, connection);
    }

    public void upload(String areaNodeUri, String projectUri) throws UnableToSaveException {
        String uploadUrl;
        TFSTeamProjectCollection connection = this.getAssociatedCollection().getWorkItemInternal().getConnection();
        try {
            uploadUrl = this.getAssociatedCollection().getWorkItemInternal().getContext().getAttachmentServerURL();
        }
        catch (Exception ex) {
            throw new UnableToSaveException(ex);
        }
        this.serverGuid = AttachmentUpDownHelper.upload(areaNodeUri, projectUri, this.localFile, uploadUrl, connection);
        this.localFile = null;
    }

    @Override
    protected void createXMLForAdd(Element parentElement) {
        SimpleDateFormat metadataDateFormat = InternalWorkItemUtils.newMetadataDateFormat();
        Element element = DOMUtils.appendChild(parentElement, "InsertFile");
        element.setAttribute("FieldName", "System.AttachedFiles");
        element.setAttribute("OriginalName", this.fileName);
        element.setAttribute(URL_FILE_NAME_PARAMETER_NAME, this.serverGuid);
        element.setAttribute("CreationDate", metadataDateFormat.format(this.fileCreatedDate));
        element.setAttribute("LastWriteDate", metadataDateFormat.format(this.fileLastModifiedDate));
        element.setAttribute(URL_FILE_NAME_PARAMETER_NAME, this.serverGuid);
        if (this.comment != null && this.comment.trim().length() > 0) {
            DOMUtils.appendChildWithText(element, "Comment", this.comment.trim());
        }
        element.setAttribute("FileSize", String.valueOf(this.fileSize));
    }

    @Override
    protected void createXMLForRemove(Element parentElement) {
        Element element = DOMUtils.appendChild(parentElement, "RemoveFile");
        element.setAttribute(URL_FILE_ID_PARAMETER_NAME, String.valueOf(this.getExtID()));
    }

    @Override
    protected String getInsertTagName() {
        return "InsertFile";
    }

    @Override
    protected boolean isEquivalentTo(WITComponent other) {
        return false;
    }
}

