/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.link;

import com.microsoft.tfs.core.clients.linking.LinkingClient;
import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.link.LinkDescriptionUpdater;
import com.microsoft.tfs.core.clients.workitem.internal.link.LinkImpl;
import com.microsoft.tfs.core.clients.workitem.link.DescriptionUpdateErrorCallback;
import com.microsoft.tfs.core.clients.workitem.link.ExternalLink;
import java.util.HashMap;
import java.util.Map;
import ms.tfs.services.linking._03._Artifact;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExternalLinkDescriptionUpdater
implements LinkDescriptionUpdater {
    private static final Log log = LogFactory.getLog(ExternalLinkDescriptionUpdater.class);
    private final DescriptionUpdateErrorCallback errorCallback;
    private final WITContext witContext;
    private final Map urisToLinks = new HashMap();

    public ExternalLinkDescriptionUpdater(DescriptionUpdateErrorCallback errorCallback, WITContext witContext) {
        this.errorCallback = errorCallback;
        this.witContext = witContext;
    }

    @Override
    public void addLinkToBeUpdated(LinkImpl link) {
        String uri = ((ExternalLink)((Object)link)).getURI();
        this.urisToLinks.put(uri, link);
    }

    @Override
    public void run() {
        if (this.urisToLinks.size() == 0) {
            return;
        }
        try {
            LinkingClient linkingClient = (LinkingClient)this.witContext.getConnection().getClient(LinkingClient.class);
            String[] artifactUriList = this.urisToLinks.keySet().toArray(new String[0]);
            _Artifact[] artifacts = linkingClient.getArtifacts(artifactUriList);
            for (int i = 0; i < artifacts.length; ++i) {
                LinkImpl link;
                if (artifacts[i] == null || (link = (LinkImpl)this.urisToLinks.get(artifacts[i].getUri())) == null) continue;
                link.setDescription(artifacts[i].getArtifactTitle());
            }
        }
        catch (Throwable t) {
            if (this.errorCallback != null) {
                this.errorCallback.onDescriptionUpdateError(t);
            }
            log.error((Object)t);
        }
    }
}

