/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.link;

import com.microsoft.tfs.core.clients.registration.OutboundLinkType;
import com.microsoft.tfs.core.clients.registration.RegistrationClient;
import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.link.RegisteredLinkTypeImpl;
import com.microsoft.tfs.core.clients.workitem.link.RegisteredLinkType;
import com.microsoft.tfs.core.clients.workitem.link.RegisteredLinkTypeCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RegisteredLinkTypeCollectionImpl
implements RegisteredLinkTypeCollection {
    private final List<RegisteredLinkType> types = new ArrayList<RegisteredLinkType>();
    private final Map<String, RegisteredLinkType> nameToType = new HashMap<String, RegisteredLinkType>();

    public RegisteredLinkTypeCollectionImpl(WITContext context) {
        RegistrationClient registrationClient = context.getConnection().getRegistrationClient();
        OutboundLinkType[] outboundLinkTypes = registrationClient.getOutboundLinkTypes("WorkItemTracking", "WorkItem");
        for (int i = 0; i < outboundLinkTypes.length; ++i) {
            RegisteredLinkTypeImpl linkType = new RegisteredLinkTypeImpl(outboundLinkTypes[i].getName());
            this.types.add(linkType);
            this.nameToType.put(linkType.getName(), linkType);
        }
    }

    public String toString() {
        return this.types.toString();
    }

    @Override
    public Iterator<RegisteredLinkType> iterator() {
        return this.types.iterator();
    }

    @Override
    public boolean contains(RegisteredLinkType linkType) {
        return this.types.contains(linkType);
    }

    @Override
    public int size() {
        return this.types.size();
    }

    @Override
    public RegisteredLinkType get(String name) {
        return this.nameToType.get(name);
    }
}

