/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.project;

import com.microsoft.tfs.core.clients.workitem.WorkItemClient;
import com.microsoft.tfs.core.clients.workitem.exceptions.DeniedOrNotExistException;
import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.node.NodeImpl;
import com.microsoft.tfs.core.clients.workitem.internal.project.ProjectImpl;
import com.microsoft.tfs.core.clients.workitem.node.Node;
import com.microsoft.tfs.core.clients.workitem.project.Project;
import com.microsoft.tfs.core.clients.workitem.project.ProjectCollection;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ProjectCollectionImpl
implements ProjectCollection {
    private final WITContext witContext;
    private final Set<Project> projects = new HashSet<Project>();
    private final Map<String, Project> nameToProjectMap = new HashMap<String, Project>();
    private final Map<Integer, Project> idToProjectMap = new HashMap<Integer, Project>();

    public ProjectCollectionImpl(WITContext witContext) {
        this.witContext = witContext;
        this.populate();
    }

    @Override
    public Iterator<Project> iterator() {
        return Collections.unmodifiableCollection(this.projects).iterator();
    }

    @Override
    public int size() {
        return this.projects.size();
    }

    @Override
    public Project get(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        return this.nameToProjectMap.get(name.toLowerCase());
    }

    @Override
    public Project getByID(int id) {
        Integer idKey = new Integer(id);
        if (!this.idToProjectMap.containsKey(idKey)) {
            throw new DeniedOrNotExistException();
        }
        return this.idToProjectMap.get(new Integer(id));
    }

    @Override
    public Project[] getProjects() {
        Object[] returnArray = this.projects.toArray(new Project[0]);
        Arrays.sort(returnArray);
        return returnArray;
    }

    @Override
    public WorkItemClient getClient() {
        return this.witContext.getClient();
    }

    private void populate() {
        Iterator<Node> it = this.witContext.getRootNode().getChildNodes().iterator();
        while (it.hasNext()) {
            Node projectNode = it.next();
            if (!(projectNode instanceof NodeImpl)) continue;
            this.addProject(new ProjectImpl((NodeImpl)projectNode, this.witContext));
        }
    }

    private void addProject(Project project) {
        this.projects.add(project);
        this.nameToProjectMap.put(project.getName().toLowerCase(), project);
        this.idToProjectMap.put(new Integer(project.getID()), project);
    }
}

