/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.internal.persistence;

import com.microsoft.tfs.core.persistence.ObjectSerializer;
import com.microsoft.tfs.core.ws.runtime.stax.StaxFactoryProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public abstract class StaxSerializer
implements ObjectSerializer {
    private static final String ENCODING = "UTF-8";
    private static final Object xmlInputFactoryLock = new Object();
    private static XMLInputFactory xmlInputFactory;
    private static final Object xmlOutputFactoryLock;
    private static XMLOutputFactory xmlOutputFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static XMLOutputFactory getXMLOutputFactory() {
        Object object = xmlOutputFactoryLock;
        synchronized (object) {
            if (xmlOutputFactory == null) {
                xmlOutputFactory = StaxFactoryProvider.getXMLOutputFactory();
            }
            return xmlOutputFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static XMLInputFactory getXMLInputFactory() {
        Object object = xmlInputFactoryLock;
        synchronized (object) {
            if (xmlInputFactory == null) {
                xmlInputFactory = StaxFactoryProvider.getXMLInputFactory(true);
            }
            return xmlInputFactory;
        }
    }

    @Override
    public Object deserialize(InputStream inputStream) throws IOException, InterruptedException {
        try {
            XMLInputFactory factory = StaxSerializer.getXMLInputFactory();
            factory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
            XMLStreamReader reader = factory.createXMLStreamReader(inputStream, ENCODING);
            return this.deserialize(reader);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void serialize(Object object, OutputStream outputStream) throws IOException, InterruptedException {
        try {
            XMLStreamWriter writer = StaxSerializer.getXMLOutputFactory().createXMLStreamWriter(outputStream, ENCODING);
            writer.writeStartDocument();
            this.serialize(object, writer);
            writer.writeEndDocument();
            writer.flush();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract void serialize(Object var1, XMLStreamWriter var2) throws XMLStreamException, IOException, InterruptedException;

    protected abstract Object deserialize(XMLStreamReader var1) throws XMLStreamException, IOException, InterruptedException;

    protected final void readToElementEnd(XMLStreamReader reader) throws XMLStreamException {
        int event;
        int depth = 0;
        while ((event = reader.next()) != 2 || depth > 0) {
            if (event == 1) {
                ++depth;
                continue;
            }
            if (event != 2) continue;
            --depth;
        }
    }

    protected final String readTextToElementEnd(XMLStreamReader reader) throws XMLStreamException {
        int event;
        StringBuffer buffer = new StringBuffer();
        int depth = 0;
        while ((event = reader.next()) != 2 || depth > 0) {
            if (event == 1) {
                ++depth;
            } else if (event == 2) {
                --depth;
            }
            if (event != 4 || depth != 0) continue;
            buffer.append(reader.getText());
        }
        return buffer.toString();
    }

    protected final void createChildTextElement(XMLStreamWriter writer, String elementName, String text) throws XMLStreamException {
        writer.writeStartElement(elementName);
        writer.writeCharacters(text);
        writer.writeEndElement();
    }

    static {
        xmlOutputFactoryLock = new Object();
    }
}

