/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.util.serverlist;

import com.microsoft.tfs.core.util.ServerURIComparator;
import com.microsoft.tfs.core.util.serverlist.ServerListConfigurationEntry;
import com.microsoft.tfs.util.Check;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class ServerList {
    private final Set<ServerListConfigurationEntry> serverSet = new TreeSet<ServerListConfigurationEntry>();
    private final Map<URI, ServerListConfigurationEntry> uriMap = new TreeMap<URI, ServerListConfigurationEntry>(ServerURIComparator.INSTANCE);

    public void add(ServerListConfigurationEntry server) {
        Check.notNull(server, "server");
        URI uri = server.getURI();
        ServerListConfigurationEntry existingEntry = this.uriMap.remove(uri);
        if (existingEntry != null) {
            this.serverSet.remove(existingEntry);
        }
        this.serverSet.add(server);
        this.uriMap.put(uri, server);
    }

    public void addAll(Collection<ServerListConfigurationEntry> servers) {
        Check.notNull(servers, "servers");
        for (ServerListConfigurationEntry server : servers) {
            this.add(server);
        }
    }

    public void remove(ServerListConfigurationEntry server) {
        Check.notNull(server, "server");
        if (this.serverSet.remove(server)) {
            this.uriMap.remove(server.getURI());
        }
    }

    public void removeAll(Collection<ServerListConfigurationEntry> servers) {
        Check.notNull(servers, "servers");
        for (ServerListConfigurationEntry server : servers) {
            this.remove(server);
        }
    }

    public boolean contains(URI uri) {
        return this.uriMap.containsKey(uri);
    }

    public boolean contains(ServerListConfigurationEntry server) {
        return this.serverSet.contains(server);
    }

    public ServerListConfigurationEntry getServer(URI uri) {
        return this.uriMap.get(uri);
    }

    public Set<ServerListConfigurationEntry> getServers() {
        return this.serverSet;
    }
}

