/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.htmlfilter;

import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.htmlfilter.AllowedHTMLTags;
import com.microsoft.tfs.util.htmlfilter.HTMLSimpleWriter;
import com.microsoft.tfs.util.htmlfilter.IHTMLFilterWriter;

public class HTMLFilter {
    public static String strip(String html) {
        Check.notNull(html, "html");
        HTMLSimpleWriter writer = new HTMLSimpleWriter();
        HTMLFilter.parse(html, writer);
        return writer.toString();
    }

    private static int skipWhiteSpaces(String html, int offset) {
        int n = html.length();
        while (offset < n && (Character.isWhitespace(html.charAt(offset)) || Character.isISOControl(html.charAt(offset)))) {
            ++offset;
        }
        Check.isTrue(offset == n || !Character.isWhitespace(html.charAt(offset)) && !Character.isISOControl(html.charAt(offset)), "offset == n || !Character.isWhitespace(html.charAt(offset)) && !Character.isISOControl(html.charAt(offset))");
        return offset;
    }

    private static int skipUntil(String html, int offset, char terminatorChar) {
        int n = html.length();
        while (offset < n && html.charAt(offset++) != terminatorChar) {
        }
        Check.isTrue(offset == n || html.charAt(offset - 1) == terminatorChar, "offset == n || html.charAt(offset - 1) == terminatorChar");
        return offset;
    }

    private static int skipUntil(String html, int offset, char terminatorChar1, char terminatorChar2, char terminatorChar3) {
        int n = html.length();
        while (offset + 2 < n && (html.charAt(offset) != terminatorChar1 || html.charAt(offset + 1) != terminatorChar2 || html.charAt(offset + 2) != terminatorChar3)) {
            ++offset;
        }
        offset = offset + 2 < n ? (offset += 3) : n;
        Check.isTrue(offset == n || html.charAt(offset - 3) == terminatorChar1 && html.charAt(offset - 2) == terminatorChar2 && html.charAt(offset - 1) == terminatorChar3, "offset == n || html.charAt(offset - 3) == terminatorChar1 && html.charAt(offset - 2) == terminatorChar2 && html.charAt(offset - 1) == terminatorChar3");
        return offset;
    }

    private static ScanResult scanName(String html, int offset) {
        int n = html.length();
        int i0 = offset;
        while (offset < n && (Character.isLetterOrDigit(html.charAt(offset)) || html.charAt(offset) == ':' || html.charAt(offset) == '_')) {
            ++offset;
        }
        return new ScanResult(offset, html.substring(i0, offset));
    }

    private static void parse(String html, IHTMLFilterWriter writer) {
        int n = html.length();
        int i = 0;
        block0: while (i < n) {
            ScanResult innerScanResult;
            int i0 = i;
            while (i < n && html.charAt(i) != '<') {
                ++i;
            }
            if (i > i0) {
                writer.writeText(html, i0, i - i0);
                continue;
            }
            Check.isTrue(i < n && html.charAt(i) == '<', "i < n && html.charAt(i) == '<'");
            i0 = i++;
            if (i < n && html.charAt(i) == '!') {
                if (++i + 1 < n && html.charAt(i) == '-' && html.charAt(i + 1) == '-') {
                    i += 2;
                    i = HTMLFilter.skipUntil(html, i, '-', '-', '>');
                    continue;
                }
                if (i + 6 < n && html.charAt(i) == '[' && html.charAt(i + 1) == 'C' && html.charAt(i + 2) == 'D' && html.charAt(i + 3) == 'A' && html.charAt(i + 4) == 'T' && html.charAt(i + 5) == 'A' && html.charAt(i + 6) == '[') {
                    i += 7;
                    i = HTMLFilter.skipUntil(html, i, ']', ']', '>');
                    continue;
                }
                i = HTMLFilter.skipUntil(html, i, '>');
                continue;
            }
            if (i < n && html.charAt(i) == '?') {
                ++i;
                i = HTMLFilter.skipUntil(html, i, '>');
                continue;
            }
            boolean endTag = false;
            if (i < n && html.charAt(i) == '/') {
                endTag = true;
                ++i;
            }
            i = HTMLFilter.skipWhiteSpaces(html, i);
            ScanResult scanResult = HTMLFilter.scanName(html, i);
            String tag = scanResult.tag;
            i = scanResult.offset;
            if (AllowedHTMLTags.isSpecialTag(tag)) {
                i = HTMLFilter.skipUntil(html, i, '>');
                while (i < n) {
                    if ((i = HTMLFilter.skipUntil(html, i, '<')) + 2 < n && html.charAt(i) == '!' && html.charAt(i + 1) == '-' && html.charAt(i + 2) == '-') {
                        i = HTMLFilter.skipUntil(html, i, '-', '-', '>');
                        continue;
                    }
                    if (i < n && html.charAt(i) == '/') {
                        ++i;
                        i = HTMLFilter.skipWhiteSpaces(html, i);
                        innerScanResult = HTMLFilter.scanName(html, i);
                        i = innerScanResult.offset;
                        String etag = innerScanResult.tag;
                        if (!AllowedHTMLTags.areTagsEqual(tag, etag)) continue;
                        i = HTMLFilter.skipUntil(html, i, '>');
                        continue block0;
                    }
                    if (i >= n) continue;
                    ++i;
                }
                continue;
            }
            if (!AllowedHTMLTags.isAllowedTag(tag)) {
                i = HTMLFilter.skipUntil(html, i, '>');
                continue;
            }
            writer.writeTag(html, i0, i - i0, tag, endTag);
            while (i < n) {
                i0 = i;
                if ((i = HTMLFilter.skipWhiteSpaces(html, i)) < n && html.charAt(i) == '/') {
                    ++i;
                }
                if (i < n && html.charAt(i) == '>') {
                    writer.writeEndOfTag(html, i0, ++i - i0, tag);
                    continue block0;
                }
                if (i < n && Character.isLetterOrDigit(html.charAt(i))) {
                    innerScanResult = HTMLFilter.scanName(html, i);
                    i = innerScanResult.offset;
                    String attr = innerScanResult.tag;
                    i = HTMLFilter.skipWhiteSpaces(html, i);
                    int i1 = 0;
                    int i2 = 0;
                    if (i < n && html.charAt(i) == '=') {
                        ++i;
                        i1 = i = HTMLFilter.skipWhiteSpaces(html, i);
                        if (i < n && (html.charAt(i) == '\'' || html.charAt(i) == '\"')) {
                            char term = html.charAt(i++);
                            i1 = i;
                            while (i < n && html.charAt(i) != '>' && html.charAt(i) != term) {
                                ++i;
                            }
                            i2 = i;
                            if (i < n && html.charAt(i) == term) {
                                ++i;
                            }
                        } else {
                            while (i < n && html.charAt(i) != '>' && !Character.isWhitespace(html.charAt(i)) && !Character.isISOControl(html.charAt(i))) {
                                ++i;
                            }
                            i2 = i;
                        }
                        if (i >= i1 + 11 && AllowedHTMLTags.areTagsEqual(html.substring(i1, i1 + 11), "javascript:")) {
                            attr = "";
                        }
                    }
                    if (!AllowedHTMLTags.isAllowedAttribute(tag, attr)) continue;
                    writer.writeAttribute(html, i0, i - i0, tag, attr, i1, i2);
                    continue;
                }
                if (i >= n || html.charAt(i) == '>') continue;
                ++i;
            }
        }
        Check.isTrue(i == n, "i == n");
    }

    private static class ScanResult {
        public final int offset;
        public final String tag;

        public ScanResult(int offset, String tag) {
            this.offset = offset;
            this.tag = tag;
        }
    }
}

