/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.commons.service.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.google.common.io.CharStreams;
import com.teamscale.commons.service.EMimeType;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.lib.commons.function.FunctionWithException;

public interface IDeserializationFormat<T> {
    public Optional<EMimeType> getMimeType();

    public T deserialize(Reader var1) throws IOException;

    public static <T> IDeserializationFormat<T> fromJson(Class<T> elementType) {
        return IDeserializationFormat.fromJson(serializedData -> JsonUtils.deserializeFromJson(serializedData, elementType));
    }

    public static <T> IDeserializationFormat<T> fromJson(TypeReference<T> elementType) {
        return IDeserializationFormat.fromJson(serializedData -> JsonUtils.deserializeFromJson(serializedData, elementType));
    }

    public static <T> IDeserializationFormat<List<T>> fromJsonList(Class<T> elementType) {
        JavaType listType = JsonUtils.getJavaListType(elementType);
        return IDeserializationFormat.fromJson(serializedData -> (List)JsonUtils.deserializeFromJson(serializedData, listType));
    }

    public static <T> IDeserializationFormat<T> fromJson(final FunctionWithException<Reader, T, JsonSerializationException> deserializer) {
        return new IDeserializationFormat<T>(){

            @Override
            public Optional<EMimeType> getMimeType() {
                return Optional.of(EMimeType.JSON);
            }

            @Override
            public T deserialize(Reader serializedData) throws IOException {
                try {
                    return deserializer.apply((Object)serializedData);
                }
                catch (JsonSerializationException e) {
                    throw new IOException(e.getMessage(), (Throwable)((Object)e));
                }
            }
        };
    }

    public static IDeserializationFormat<String> asPlainText() {
        return new IDeserializationFormat<String>(){

            @Override
            public Optional<EMimeType> getMimeType() {
                return Optional.of(EMimeType.PLAIN);
            }

            @Override
            public String deserialize(Reader serializedData) throws IOException {
                return CharStreams.toString((Readable)serializedData);
            }
        };
    }

    public static IDeserializationFormat<String> asUnspecifiedPlainText() {
        return new IDeserializationFormat<String>(){

            @Override
            public Optional<EMimeType> getMimeType() {
                return Optional.empty();
            }

            @Override
            public String deserialize(Reader serializedData) throws IOException {
                return CharStreams.toString((Readable)serializedData);
            }
        };
    }
}

