/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.coverage;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.conqat.engine.index.shared.tests.ETestExecutionResult;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass(containedInBackup=true)
public class ExecutionUnit
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="uniformPath")
    private final String uniformPath;
    @JsonProperty(value="result")
    private @Nullable ETestExecutionResult result = null;
    @JsonProperty(value="hash")
    private @Nullable String hash = null;
    @JsonProperty(value="duration")
    private @Nullable Double durationSeconds = null;
    @JsonProperty(value="tests")
    private List<String> tests = new ArrayList<String>();
    @JsonProperty(value="externalLink")
    private @Nullable String externalLink = null;

    public ExecutionUnit(String uniformPath) {
        this.uniformPath = uniformPath;
    }

    public String getUniformPath() {
        return this.uniformPath;
    }

    public @Nullable ETestExecutionResult getResult() {
        return this.result;
    }

    public void setResult(@Nullable ETestExecutionResult result) {
        this.result = result;
    }

    public @Nullable String getHash() {
        return this.hash;
    }

    public void setHash(@Nullable String hash) {
        this.hash = hash;
    }

    public @Nullable Double getDurationSeconds() {
        return this.durationSeconds;
    }

    public @Nullable Duration getDuration() {
        if (this.durationSeconds == null) {
            return null;
        }
        return Duration.ofMillis(Math.round(this.durationSeconds * 1000.0));
    }

    public void setDurationSeconds(@Nullable Double durationSeconds) {
        this.durationSeconds = durationSeconds;
    }

    public List<String> getTests() {
        return this.tests;
    }

    public void addTest(String test) {
        this.tests.add(test);
    }

    public @Nullable String getExternalLink() {
        return this.externalLink;
    }

    public void setExternalLink(@Nullable String externalLink) {
        this.externalLink = externalLink;
    }

    public static ExecutionUnit merge(Collection<ExecutionUnit> executionUnits) {
        Preconditions.checkArgument((!executionUnits.isEmpty() ? 1 : 0) != 0, (Object)"Can't merge empty collection of execution units.");
        if (executionUnits.size() == 1) {
            return (ExecutionUnit)Iterables.getOnlyElement(executionUnits);
        }
        Iterator<ExecutionUnit> it = executionUnits.iterator();
        ETestExecutionResult worstResult = ETestExecutionResult.worst(it.next().getResult(), ETestExecutionResult.PASSED);
        while (it.hasNext()) {
            ExecutionUnit nextExecution = it.next();
            if (ETestExecutionResult.worst(nextExecution.getResult(), worstResult) == worstResult) continue;
            worstResult = nextExecution.getResult();
        }
        Double maxDurationSeconds = executionUnits.stream().map(ExecutionUnit::getDurationSeconds).filter(Objects::nonNull).max(Double::compare).orElse(null);
        ExecutionUnit executionUnitFromFirstParent = executionUnits.iterator().next();
        ExecutionUnit executionUnit = new ExecutionUnit(executionUnitFromFirstParent.uniformPath);
        executionUnit.setResult(worstResult);
        executionUnit.setDurationSeconds(maxDurationSeconds);
        executionUnit.setHash(executionUnitFromFirstParent.hash);
        executionUnits.stream().map(ExecutionUnit::getTests).flatMap(Collection::stream).distinct().forEach(executionUnit::addTest);
        executionUnit.setExternalLink(executionUnitFromFirstParent.externalLink);
        return executionUnit;
    }
}

