/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.core.logging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.time.Instant;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.core.logging.LogEventCollector;
import org.conqat.engine.core.logging.LoggingEventTransport;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NullMarked;

class LogEventCollection {
    private static final int MAX_LOG_MESSAGES = 10000;
    public static final LogEventCollection EMPTY = new LogEventCollection();
    private static final Comparator<LogEvent> LOG_EVENT_COMPARATOR = Comparator.comparing(LogEvent::getInstant, Comparator.comparingLong(Instant::getEpochMillisecond).thenComparingLong(Instant::getNanoOfMillisecond)).thenComparingLong(LogEvent::getThreadId).thenComparingLong(System::identityHashCode);
    private ILogEventStore eventStore;

    public LogEventCollection() {
        this.eventStore = new SimpleLogEventStore();
    }

    private LogEventCollection(ILogEventStore eventStore) {
        this.eventStore = eventStore;
    }

    public void addEvent(LogEvent event) {
        this.eventStore.addEvent(event.toImmutable());
        this.eventStore = LogEventCollection.convertToTruncatingStoreIfNecessary(this.eventStore);
    }

    public static LogEventCollection merge(Collection<LogEventCollection> logEventCollections) {
        CounterSet countsPerLevel = new CounterSet();
        ArrayList<List<LogEvent>> allLogEvents = new ArrayList<List<LogEvent>>(logEventCollections.size());
        int eventCount = 0;
        for (LogEventCollection collection : logEventCollections) {
            countsPerLevel.add(collection.getCountsPerLevel());
            List<LogEvent> collectionEvents = collection.getEvents();
            allLogEvents.add(collectionEvents);
            eventCount += collectionEvents.size();
        }
        ArrayList<LogEvent> events = new ArrayList<LogEvent>(eventCount);
        Iterator iter = CollectionUtils.sortedIterator(LOG_EVENT_COMPARATOR, allLogEvents);
        while (iter.hasNext()) {
            events.add((LogEvent)iter.next());
        }
        SimpleLogEventStore merged = new SimpleLogEventStore(events, (CounterSet<Level>)countsPerLevel);
        return new LogEventCollection(LogEventCollection.convertToTruncatingStoreIfNecessary(merged));
    }

    List<LogEvent> getEvents() {
        return this.eventStore.getEvents();
    }

    CounterSet<Level> getCountsPerLevel() {
        return this.eventStore.getCountsPerLevel();
    }

    private static ILogEventStore convertToTruncatingStoreIfNecessary(ILogEventStore logStore) {
        return LogEventCollection.convertToTruncatingStoreIfNecessary(logStore, 10000);
    }

    private static ILogEventStore convertToTruncatingStoreIfNecessary(ILogEventStore logStore, int maxLogMessages) {
        if (EFeatureToggle.DISABLE_WORKER_LOG_TRUNCATION.isEnabled() || logStore.getEvents().size() <= maxLogMessages || logStore.isTruncating()) {
            return logStore;
        }
        return new TruncatingLogEventStore(logStore.getEvents(), maxLogMessages);
    }

    @TestOnly
    public static List<LoggingEventTransport> truncateEvents(List<LoggingEventTransport> loggingEventTransports, int maxLogMessages) {
        List logEvents = CollectionUtils.map(loggingEventTransports, transport -> Log4jLogEvent.newBuilder().setTimeMillis(transport.getTime()).setMessage((Message)new SimpleMessage(transport.getMessage())).setLevel(transport.getLevel().getLog4JLevel()).setLoggerName(LogEventCollector.class.getName()).build());
        return LoggingEventTransport.convertFromLog4j(LogEventCollection.convertToTruncatingStoreIfNecessary(new SimpleLogEventStore(logEvents), maxLogMessages).getEvents());
    }

    @NullMarked
    private static class SimpleLogEventStore
    implements ILogEventStore {
        private final CounterSet<Level> countsPerLevel;
        private final List<LogEvent> events;

        public SimpleLogEventStore() {
            this.events = new ArrayList<LogEvent>();
            this.countsPerLevel = new CounterSet();
        }

        public SimpleLogEventStore(List<LogEvent> events) {
            this.events = events;
            this.countsPerLevel = new CounterSet();
            for (LogEvent event : events) {
                this.countsPerLevel.inc((Object)event.getLevel());
            }
        }

        public SimpleLogEventStore(List<LogEvent> events, CounterSet<Level> countsPerLevel) {
            this.events = events;
            this.countsPerLevel = countsPerLevel;
        }

        @Override
        public List<LogEvent> getEvents() {
            return this.events;
        }

        @Override
        public CounterSet<Level> getCountsPerLevel() {
            return this.countsPerLevel;
        }

        @Override
        public void addEvent(LogEvent event) {
            this.events.add(event);
            this.countsPerLevel.inc((Object)event.getLevel());
        }

        @Override
        public boolean isTruncating() {
            return false;
        }
    }

    @NullMarked
    private static interface ILogEventStore {
        public List<LogEvent> getEvents();

        public CounterSet<Level> getCountsPerLevel();

        public void addEvent(LogEvent var1);

        public boolean isTruncating();
    }

    @NullMarked
    @VisibleForTesting
    static class TruncatingLogEventStore
    implements ILogEventStore {
        private static final Marker TRUNCATED_LOG_EVENT_INFO_MARKER = MarkerManager.getMarker((String)"truncated-log-event-info");
        private final int maxLogMessages;
        private final SortedMap<Level, List<LogEvent>> eventsByLevel;
        private final CounterSet<Level> removedMessageCountPerLevel = new CounterSet();

        public TruncatingLogEventStore(List<LogEvent> events, int maxLogMessages) {
            this.eventsByLevel = events.stream().filter(logEvent -> !TRUNCATED_LOG_EVENT_INFO_MARKER.equals((Object)logEvent.getMarker())).collect(Collectors.groupingBy(LogEvent::getLevel, () -> new TreeMap(Comparator.reverseOrder()), Collectors.toList()));
            this.maxLogMessages = maxLogMessages;
            this.truncate();
        }

        private void truncate() {
            int messagesToRemove = this.eventsByLevel.values().stream().mapToInt(List::size).sum() - this.maxLogMessages;
            Iterator iterator = this.eventsByLevel.sequencedKeySet().iterator();
            while (iterator.hasNext() && messagesToRemove != 0) {
                Level level = (Level)iterator.next();
                List events = (List)this.eventsByLevel.get(level);
                if (messagesToRemove < events.size()) {
                    this.removedMessageCountPerLevel.inc((Object)level, messagesToRemove);
                    events.subList(events.size() - messagesToRemove, events.size()).clear();
                    messagesToRemove = 0;
                    continue;
                }
                this.removedMessageCountPerLevel.inc((Object)level, events.size());
                iterator.remove();
                messagesToRemove -= events.size();
            }
        }

        @Override
        public List<LogEvent> getEvents() {
            ArrayList<LogEvent> result = new ArrayList<LogEvent>(this.maxLogMessages + 1);
            CollectionUtils.sortedIterator(LOG_EVENT_COMPARATOR.thenComparing(LogEvent::getLevel), this.eventsByLevel.values()).forEachRemaining(result::add);
            Level reduce = this.eventsByLevel.lastKey();
            result.add((LogEvent)Log4jLogEvent.newBuilder().setTimeMillis(System.currentTimeMillis()).setMessage((Message)new SimpleMessage("Log truncated because of size! Removed messages per level: %s".formatted(this.removedMessageCountPerLevel))).setLevel(reduce).setMarker(TRUNCATED_LOG_EVENT_INFO_MARKER).setLoggerName(LogEventCollector.class.getName()).build());
            return result;
        }

        @Override
        public void addEvent(LogEvent event) {
            Level lowestContainedLevel = this.eventsByLevel.firstKey();
            if (lowestContainedLevel.isMoreSpecificThan(event.getLevel())) {
                this.removedMessageCountPerLevel.inc((Object)event.getLevel());
                return;
            }
            this.eventsByLevel.computeIfAbsent(event.getLevel(), k -> new ArrayList()).add(event);
            List lowestLevelEvents = (List)this.eventsByLevel.get(lowestContainedLevel);
            lowestLevelEvents.removeLast();
            if (lowestLevelEvents.isEmpty()) {
                this.eventsByLevel.remove(lowestContainedLevel);
            }
        }

        @Override
        public boolean isTruncating() {
            return true;
        }

        @Override
        public CounterSet<Level> getCountsPerLevel() {
            CounterSet eventCounts = new CounterSet();
            for (Map.Entry<Level, List<LogEvent>> entry : this.eventsByLevel.entrySet()) {
                eventCounts.inc((Object)entry.getKey(), entry.getValue().size());
            }
            return eventCounts;
        }
    }
}

