/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import java.io.Closeable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.PersistentEntity;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.CachedInstanceIterable;
import jetbrains.exodus.entitystore.iterate.ConstantEntityIterableHandle;
import jetbrains.exodus.entitystore.iterate.EntitiesWithCertainLinkIterable;
import jetbrains.exodus.entitystore.iterate.EntityAddedOrDeletedHandleChecker;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.FilterEntitiesWithCertainLinkIterable;
import jetbrains.exodus.entitystore.iterate.UpdatableEntityIdSortedSetCachedInstanceIterable;
import jetbrains.exodus.env.BitmapImpl;
import jetbrains.exodus.env.BitmapIterator;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Transaction;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0016\u0018\u0000 \u001b2\u00020\u0001:\u0004\u001b\u001c\u001d\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0005H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Ljetbrains/exodus/entitystore/iterate/EntitiesOfTypeIterable;", "Ljetbrains/exodus/entitystore/iterate/EntityIterableBase;", "txn", "Ljetbrains/exodus/entitystore/PersistentStoreTransaction;", "entityTypeId", "", "(Ljetbrains/exodus/entitystore/PersistentStoreTransaction;I)V", "countImpl", "", "createCachedInstance", "Ljetbrains/exodus/entitystore/iterate/CachedInstanceIterable;", "findLinks", "Ljetbrains/exodus/entitystore/EntityIterable;", "entities", "linkName", "", "getEntityTypeId", "getHandleImpl", "Ljetbrains/exodus/entitystore/iterate/EntitiesOfTypeIterable$EntitiesOfTypeIterableHandle;", "getIteratorImpl", "Ljetbrains/exodus/entitystore/iterate/EntityIteratorBase;", "getLast", "Ljetbrains/exodus/entitystore/Entity;", "getReverseIteratorImpl", "isEmptyImpl", "", "nonCachedHasFastCountAndIsEmpty", "Companion", "EntitiesOfTypeBitmapIterator", "EntitiesOfTypeIterableHandle", "EntitiesOfTypeIterator", "xodus-entity-store"})
public class EntitiesOfTypeIterable
extends EntityIterableBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int entityTypeId;

    public EntitiesOfTypeIterable(@NotNull PersistentStoreTransaction txn, int entityTypeId) {
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        super(txn);
        this.entityTypeId = entityTypeId;
    }

    @Override
    public int getEntityTypeId() {
        return this.entityTypeId;
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        EntityIteratorBase entityIteratorBase;
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        if (this.getStore().useVersion1Format()) {
            Cursor cursor = this.getStore().getEntitiesIndexCursor(txn, this.entityTypeId);
            Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"store.getEntitiesIndexCursor(txn, entityTypeId)");
            entityIteratorBase = new EntitiesOfTypeIterator(this, cursor, false);
        } else {
            BitmapIterator bitmapIterator = this.getStore().getEntitiesBitmapIterator(txn, this.entityTypeId);
            Intrinsics.checkNotNullExpressionValue((Object)bitmapIterator, (String)"store.getEntitiesBitmapIterator(txn, entityTypeId)");
            entityIteratorBase = new EntitiesOfTypeBitmapIterator(this, bitmapIterator);
        }
        return entityIteratorBase;
    }

    @Override
    @NotNull
    public EntityIteratorBase getReverseIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        EntityIteratorBase entityIteratorBase;
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        if (this.getStore().useVersion1Format()) {
            Cursor cursor = this.getStore().getEntitiesIndexCursor(txn, this.entityTypeId);
            Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"store.getEntitiesIndexCursor(txn, entityTypeId)");
            entityIteratorBase = new EntitiesOfTypeIterator(this, cursor, true);
        } else {
            BitmapIterator bitmapIterator = this.getStore().getEntitiesBitmapReverseIterator(txn, this.entityTypeId);
            Intrinsics.checkNotNullExpressionValue((Object)bitmapIterator, (String)"store.getEntitiesBitmapR\u2026erator(txn, entityTypeId)");
            entityIteratorBase = new EntitiesOfTypeBitmapIterator(this, bitmapIterator);
        }
        return entityIteratorBase;
    }

    @Override
    public boolean nonCachedHasFastCountAndIsEmpty() {
        return true;
    }

    @Override
    @NotNull
    public EntityIterable findLinks(@NotNull EntityIterable entities, @NotNull String linkName) {
        Intrinsics.checkNotNullParameter((Object)entities, (String)"entities");
        Intrinsics.checkNotNullParameter((Object)linkName, (String)"linkName");
        PersistentStoreTransaction persistentStoreTransaction = this.getTransaction();
        Intrinsics.checkNotNullExpressionValue((Object)persistentStoreTransaction, (String)"transaction");
        PersistentStoreTransaction txn = persistentStoreTransaction;
        int linkId = this.getStore().getLinkId(txn, linkName, false);
        if (linkId < 0) {
            EntityIterableBase entityIterableBase = EntityIterableBase.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)entityIterableBase, (String)"EMPTY");
            return entityIterableBase;
        }
        return new FilterEntitiesWithCertainLinkIterable(txn, new EntitiesWithCertainLinkIterable(txn, this.entityTypeId, linkId), (EntityIterableBase)entities);
    }

    @Override
    public boolean isEmptyImpl(@NotNull PersistentStoreTransaction txn) {
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        return this.countImpl(txn) == 0L;
    }

    @Override
    @NotNull
    protected EntitiesOfTypeIterableHandle getHandleImpl() {
        return new EntitiesOfTypeIterableHandle(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Entity getLast() {
        PersistentEntity persistentEntity;
        Long localId;
        Long l;
        Closeable closeable;
        PersistentStoreTransaction persistentStoreTransaction = this.getStore().getAndCheckCurrentTransaction();
        Intrinsics.checkNotNullExpressionValue((Object)persistentStoreTransaction, (String)"store.andCheckCurrentTransaction");
        PersistentStoreTransaction txn = persistentStoreTransaction;
        if (this.getStore().useVersion1Format()) {
            closeable = (Closeable)this.getStore().getEntitiesIndexCursor(txn, this.entityTypeId);
            Throwable throwable = null;
            try {
                Object cursor = (Cursor)closeable;
                boolean bl = false;
                cursor = cursor.getLast() ? Long.valueOf(LongBinding.compressedEntryToLong((ByteIterable)cursor.getKey())) : (Long)null;
                l = cursor;
            }
            catch (Throwable cursor) {
                throwable = cursor;
                throw cursor;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            BitmapImpl bitmapImpl = this.getStore().getEntitiesBitmapTable(txn, this.entityTypeId);
            closeable = txn.getEnvironmentTransaction();
            Intrinsics.checkNotNullExpressionValue((Object)closeable, (String)"txn.environmentTransaction");
            long it = bitmapImpl.getLast((Transaction)closeable);
            boolean bl = false;
            l = it < 0L ? null : Long.valueOf(it);
        }
        Long l2 = localId = l;
        if (l2 == null) {
            persistentEntity = null;
        } else {
            long it = ((Number)l2).longValue();
            boolean bl = false;
            persistentEntity = txn.getEntity(new PersistentEntityId(this.entityTypeId, it));
        }
        return persistentEntity;
    }

    @Override
    @NotNull
    protected CachedInstanceIterable createCachedInstance(@NotNull PersistentStoreTransaction txn) {
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        return new UpdatableEntityIdSortedSetCachedInstanceIterable(txn, this);
    }

    @Override
    protected long countImpl(@NotNull PersistentStoreTransaction txn) {
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        return this.getStore().getEntitiesCount(txn, this.entityTypeId);
    }

    private static final EntityIterableBase _init_$lambda-3(PersistentStoreTransaction txn, PersistentEntityStoreImpl $noName_1, Object[] parameters) {
        Intrinsics.checkNotNullExpressionValue((Object)txn, (String)"txn");
        Object object = parameters[0];
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        Integer n = Integer.valueOf((String)object);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"valueOf(parameters[0] as String)");
        return new EntitiesOfTypeIterable(txn, ((Number)n).intValue());
    }

    static {
        EntityIterableBase.registerType(EntityIterableType.ALL_ENTITIES, EntitiesOfTypeIterable::_init_$lambda-3);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010\u0011\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u0012\u001a\u00020\u0007H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\nH\u0016R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ljetbrains/exodus/entitystore/iterate/EntitiesOfTypeIterable$EntitiesOfTypeIterator;", "Ljetbrains/exodus/entitystore/iterate/EntityIteratorBase;", "iterable", "Ljetbrains/exodus/entitystore/iterate/EntitiesOfTypeIterable;", "index", "Ljetbrains/exodus/env/Cursor;", "reverse", "", "(Ljetbrains/exodus/entitystore/iterate/EntitiesOfTypeIterable;Ljetbrains/exodus/env/Cursor;Z)V", "entityId", "Ljetbrains/exodus/entitystore/EntityId;", "getEntityId", "()Ljetbrains/exodus/entitystore/EntityId;", "entityTypeId", "", "hasNext", "hasNextValid", "getLast", "hasNextImpl", "nextIdImpl", "xodus-entity-store"})
    private static final class EntitiesOfTypeIterator
    extends EntityIteratorBase {
        private final boolean reverse;
        private boolean hasNext;
        private boolean hasNextValid;
        private final int entityTypeId;

        public EntitiesOfTypeIterator(@NotNull EntitiesOfTypeIterable iterable2, @NotNull Cursor index2, boolean reverse) {
            Intrinsics.checkNotNullParameter((Object)iterable2, (String)"iterable");
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            super(iterable2);
            this.reverse = reverse;
            this.entityTypeId = iterable2.entityTypeId;
            this.setCursor(index2);
        }

        private final EntityId getEntityId() {
            return new PersistentEntityId(this.entityTypeId, LongBinding.compressedEntryToLong((ByteIterable)this.getCursor().getKey()));
        }

        @Override
        public boolean hasNextImpl() {
            if (!this.hasNextValid) {
                this.hasNext = this.reverse ? this.getCursor().getPrev() : this.getCursor().getNext();
                this.hasNextValid = true;
            }
            return this.hasNext;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            if (this.hasNextImpl()) {
                this.getIterable().explain(EntityIterableType.ALL_ENTITIES);
                EntityId result = this.getEntityId();
                this.hasNextValid = false;
                return result;
            }
            return null;
        }

        @Override
        @Nullable
        public EntityId getLast() {
            return !this.getCursor().getPrev() ? null : this.getEntityId();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\bH\u0016R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Ljetbrains/exodus/entitystore/iterate/EntitiesOfTypeIterable$EntitiesOfTypeBitmapIterator;", "Ljetbrains/exodus/entitystore/iterate/EntityIteratorBase;", "iterable", "Ljetbrains/exodus/entitystore/iterate/EntitiesOfTypeIterable;", "iterator", "Ljetbrains/exodus/env/BitmapIterator;", "(Ljetbrains/exodus/entitystore/iterate/EntitiesOfTypeIterable;Ljetbrains/exodus/env/BitmapIterator;)V", "entityId", "Ljetbrains/exodus/entitystore/EntityId;", "getEntityId", "()Ljetbrains/exodus/entitystore/EntityId;", "entityKey", "", "entityTypeId", "", "getIterator", "()Ljetbrains/exodus/env/BitmapIterator;", "hasNextImpl", "", "nextIdImpl", "xodus-entity-store"})
    private static final class EntitiesOfTypeBitmapIterator
    extends EntityIteratorBase {
        @NotNull
        private final BitmapIterator iterator;
        private final int entityTypeId;
        private long entityKey;

        public EntitiesOfTypeBitmapIterator(@NotNull EntitiesOfTypeIterable iterable2, @NotNull BitmapIterator iterator) {
            Intrinsics.checkNotNullParameter((Object)iterable2, (String)"iterable");
            Intrinsics.checkNotNullParameter((Object)iterator, (String)"iterator");
            super(iterable2);
            this.iterator = iterator;
            this.setCursor(this.iterator.getCursor());
            this.entityTypeId = iterable2.entityTypeId;
            this.entityKey = -1L;
        }

        @NotNull
        public final BitmapIterator getIterator() {
            return this.iterator;
        }

        private final EntityId getEntityId() {
            return new PersistentEntityId(this.entityTypeId, this.entityKey);
        }

        @Override
        public boolean hasNextImpl() {
            return this.iterator.hasNext();
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            if (this.hasNextImpl()) {
                this.getIterable().explain(EntityIterableType.ALL_ENTITIES);
                this.entityKey = this.iterator.nextLong();
                return this.getEntityId();
            }
            return null;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0014\u0010\u0018\u001a\u00020\u000b2\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Ljetbrains/exodus/entitystore/iterate/EntitiesOfTypeIterable$EntitiesOfTypeIterableHandle;", "Ljetbrains/exodus/entitystore/iterate/ConstantEntityIterableHandle;", "source", "Ljetbrains/exodus/entitystore/iterate/EntitiesOfTypeIterable;", "(Ljetbrains/exodus/entitystore/iterate/EntitiesOfTypeIterable;)V", "typeId", "", "getEntityTypeId", "getTypeIdsAffectingCreation", "", "hashCode", "", "hash", "Ljetbrains/exodus/entitystore/iterate/EntityIterableHandleBase$EntityIterableHandleHash;", "isMatchedEntityAdded", "", "added", "Ljetbrains/exodus/entitystore/EntityId;", "isMatchedEntityDeleted", "deleted", "onEntityAdded", "handleChecker", "Ljetbrains/exodus/entitystore/iterate/EntityAddedOrDeletedHandleChecker;", "onEntityDeleted", "toString", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "xodus-entity-store"})
    public static class EntitiesOfTypeIterableHandle
    extends ConstantEntityIterableHandle {
        private final int typeId;

        public EntitiesOfTypeIterableHandle(@NotNull EntitiesOfTypeIterable source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            super(source.getStore(), EntityIterableType.ALL_ENTITIES);
            this.typeId = source.entityTypeId;
        }

        @Override
        public void toString(@NotNull StringBuilder builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            super.toString(builder);
            builder.append(this.getEntityTypeId());
        }

        @Override
        public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            hash.apply(this.getEntityTypeId());
        }

        @Override
        public int getEntityTypeId() {
            return this.typeId;
        }

        @Override
        @NotNull
        public int[] getTypeIdsAffectingCreation() {
            int[] nArray = new int[]{this.getEntityTypeId()};
            return nArray;
        }

        @Override
        public boolean isMatchedEntityAdded(@NotNull EntityId added) {
            Intrinsics.checkNotNullParameter((Object)added, (String)"added");
            return added.getTypeId() == this.getEntityTypeId();
        }

        @Override
        public boolean isMatchedEntityDeleted(@NotNull EntityId deleted) {
            Intrinsics.checkNotNullParameter((Object)deleted, (String)"deleted");
            return deleted.getTypeId() == this.getEntityTypeId();
        }

        @Override
        public boolean onEntityAdded(@NotNull EntityAddedOrDeletedHandleChecker handleChecker) {
            Intrinsics.checkNotNullParameter((Object)handleChecker, (String)"handleChecker");
            UpdatableEntityIdSortedSetCachedInstanceIterable iterable2 = PersistentStoreTransaction.getUpdatable(handleChecker, this, UpdatableEntityIdSortedSetCachedInstanceIterable.class);
            if (iterable2 != null) {
                iterable2.addEntity(handleChecker.getId());
                return true;
            }
            return false;
        }

        @Override
        public boolean onEntityDeleted(@NotNull EntityAddedOrDeletedHandleChecker handleChecker) {
            Intrinsics.checkNotNullParameter((Object)handleChecker, (String)"handleChecker");
            UpdatableEntityIdSortedSetCachedInstanceIterable iterable2 = PersistentStoreTransaction.getUpdatable(handleChecker, this, UpdatableEntityIdSortedSetCachedInstanceIterable.class);
            if (iterable2 != null) {
                iterable2.removeEntity(handleChecker.getId());
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/exodus/entitystore/iterate/EntitiesOfTypeIterable$Companion;", "", "()V", "xodus-entity-store"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

