/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.HashMap;
import java.util.Map;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;

public class BidirectionalMap<S, T> {
    private final Map<S, T> stMap;
    private final Map<T, S> tsMap;

    public BidirectionalMap() {
        this.stMap = new HashMap<S, T>();
        this.tsMap = new HashMap<T, S>();
    }

    public BidirectionalMap(Map<S, T> stMap, Map<T, S> tsMap) {
        CCSMAssert.isTrue(stMap != null && tsMap != null, "Maps may not be null!");
        CCSMAssert.isTrue(stMap != tsMap, "Maps may not be equal!");
        CCSMAssert.isTrue(stMap.isEmpty() && tsMap.isEmpty(), "Maps may not be used (filled)!");
        this.stMap = stMap;
        this.tsMap = tsMap;
    }

    public S getFirst(T t) {
        return this.tsMap.get(t);
    }

    public T getSecond(S s) {
        return this.stMap.get(s);
    }

    public boolean isEmpty() {
        return this.stMap.isEmpty();
    }

    public int size() {
        return this.stMap.size();
    }

    public void clear() {
        this.stMap.clear();
        this.tsMap.clear();
    }

    public boolean containsFirst(S s) {
        return this.stMap.containsKey(s);
    }

    public boolean containsSecond(T t) {
        return this.tsMap.containsKey(t);
    }

    public UnmodifiableSet<S> getFirstSet() {
        return CollectionUtils.asUnmodifiable(this.stMap.keySet());
    }

    public UnmodifiableSet<T> getSecondSet() {
        return CollectionUtils.asUnmodifiable(this.tsMap.keySet());
    }

    public UnmodifiableSet<Map.Entry<S, T>> getEntrySet() {
        return CollectionUtils.asUnmodifiable(this.stMap.entrySet());
    }

    public UnmodifiableSet<Map.Entry<T, S>> getInvertedEntrySet() {
        return CollectionUtils.asUnmodifiable(this.tsMap.entrySet());
    }

    public void put(S s, T t) {
        CCSMAssert.isTrue(s != null && t != null, "null values not supported.");
        this.removeFirst(s);
        this.removeSecond(t);
        this.stMap.put(s, t);
        this.tsMap.put(t, s);
    }

    public void removeFirst(S s) {
        T t = this.stMap.get(s);
        if (t != null) {
            this.stMap.remove(s);
            this.tsMap.remove(t);
        }
    }

    public void removeSecond(T t) {
        S s = this.tsMap.get(t);
        if (s != null) {
            this.stMap.remove(s);
            this.tsMap.remove(t);
        }
    }

    public String toString() {
        return this.stMap.toString();
    }
}

