/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.options;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.stream.Collectors;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.string.StringUtils;

public class Options {
    public static final int OPTION_NOT_PRESENT = -1;
    private Properties properties;

    public Options() {
        this.init();
    }

    public void init(String filename) throws IOException {
        this.properties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(filename);){
            this.properties.load(inputStream);
        }
    }

    public void init() {
        this.properties = new Properties();
    }

    public boolean setOption(String option, String value) {
        boolean overridden = this.hasOption(option);
        this.properties.setProperty(option, value);
        return overridden;
    }

    public String getValue(String option) {
        if (!this.hasOption(option)) {
            return null;
        }
        String value = this.properties.getProperty(option);
        if ("".equals(value)) {
            return null;
        }
        return value;
    }

    public String getValue(String option, String defaultValue) {
        if (this.hasOption(option)) {
            return this.getValue(option);
        }
        return defaultValue;
    }

    public String[] getValues(String option) {
        if (!this.hasOption(option)) {
            return null;
        }
        String values = this.properties.getProperty(option);
        if ("".equals(values)) {
            return null;
        }
        return Options.parse(values);
    }

    public boolean hasBooleanValue(String option) {
        if (!this.hasValue(option)) {
            return false;
        }
        String value = this.getValue(option);
        return Options.checkTrue(value) || Options.checkFalse(value);
    }

    public boolean getBooleanValue(String option) throws ValueConversionException {
        if (!this.hasBooleanValue(option)) {
            throw new ValueConversionException(option);
        }
        String value = this.getValue(option);
        return Options.checkTrue(value);
    }

    public <T extends Enum<T>> T getEnumValue(String option, Class<T> enumType) throws ValueConversionException {
        if (!this.hasEnumValue(option, enumType)) {
            throw new ValueConversionException(option);
        }
        String value = this.getValue(option);
        return EnumUtils.valueOfIgnoreCase(enumType, Options.normalizeEnumConstantName(value));
    }

    public <T extends Enum<T>> T getEnumValue(String option, T defaultValue, Class<T> enumType) {
        try {
            return this.getEnumValue(option, enumType);
        }
        catch (ValueConversionException e) {
            return defaultValue;
        }
    }

    public <T extends Enum<T>> boolean hasEnumValue(String option, Class<T> enumType) {
        if (!this.hasValue(option)) {
            return false;
        }
        String value = this.getValue(option);
        return Options.checkEnum(value, enumType);
    }

    private static <T extends Enum<T>> boolean checkEnum(String value, Class<T> enumType) {
        T t = EnumUtils.valueOfIgnoreCase(enumType, Options.normalizeEnumConstantName(value));
        return t != null;
    }

    public int getIntValue(String option) throws ValueConversionException {
        if (!this.hasIntValue(option)) {
            throw new ValueConversionException(option);
        }
        String value = this.getValue(option);
        return Integer.parseInt(value);
    }

    public boolean hasIntValue(String option) {
        if (!this.hasValue(option)) {
            return false;
        }
        String value = this.getValue(option);
        return Options.checkInt(value);
    }

    public boolean getBooleanValue(String option, boolean defaultValue) {
        try {
            return this.getBooleanValue(option);
        }
        catch (ValueConversionException e) {
            return defaultValue;
        }
    }

    public int getIntValue(String option, int defaultValue) {
        try {
            return this.getIntValue(option);
        }
        catch (ValueConversionException e) {
            return defaultValue;
        }
    }

    private static boolean checkInt(String value) {
        try {
            Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    private static boolean checkFalse(String value) {
        return (value = value.trim()).equalsIgnoreCase("false") || value.equalsIgnoreCase("no");
    }

    private static boolean checkTrue(String value) {
        return (value = value.trim()).equalsIgnoreCase("true") || value.equalsIgnoreCase("yes");
    }

    private static String[] parse(String string) {
        String parameter;
        int i;
        string = string.trim();
        int length = string.length();
        char[] content = new char[length];
        string.getChars(0, length, content, 0);
        ArrayList<String> list = new ArrayList<String>();
        int lastPos = 0;
        boolean inQM = false;
        boolean inToken = false;
        block4: for (i = 0; i < length; ++i) {
            switch (content[i]) {
                case '\t': 
                case ' ': {
                    if (inToken && !inQM) {
                        parameter = string.substring(lastPos, i).trim();
                        parameter = parameter.replaceAll("\"", "");
                        list.add(parameter);
                        lastPos = i;
                    }
                    inToken = false;
                    continue block4;
                }
                case '\"': {
                    inQM = !inQM;
                    continue block4;
                }
                default: {
                    inToken = true;
                }
            }
        }
        parameter = string.substring(lastPos, i).trim();
        parameter = parameter.replaceAll("\"", "");
        list.add(parameter);
        String[] result = new String[list.size()];
        list.toArray(result);
        return result;
    }

    public boolean hasOption(String option) {
        return this.properties.getProperty(option) != null;
    }

    public boolean hasValue(String option) {
        return this.countValues(option) > 0;
    }

    public int countValues(String option) {
        if (!this.hasOption(option)) {
            return -1;
        }
        String[] values = this.getValues(option);
        if (values == null) {
            return 0;
        }
        return values.length;
    }

    public String toString() {
        return this.properties.entrySet().stream().map(entry -> String.valueOf(entry.getKey()) + " = " + String.valueOf(entry.getValue())).collect(Collectors.joining(StringUtils.LINE_SEPARATOR));
    }

    public float getFloatValue(String option) throws ValueConversionException {
        if (!this.hasFloatValue(option)) {
            throw new ValueConversionException(option);
        }
        String value = this.getValue(option);
        return Float.parseFloat(value);
    }

    public boolean hasFloatValue(String option) {
        if (!this.hasValue(option)) {
            return false;
        }
        String value = this.getValue(option);
        return Options.checkFloat(value);
    }

    private static boolean checkFloat(String value) {
        try {
            Float.parseFloat(value);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    private static String normalizeEnumConstantName(String constantName) {
        return constantName.replace("-", "_");
    }

    public static class ValueConversionException
    extends Exception {
        public ValueConversionException(String option) {
            super("Option: " + option);
        }
    }
}

