/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.abap.checks;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.conqat.engine.abap.ParsedAbapElementPath;
import org.conqat.engine.abap.checks.AbapObjectNamingRule;
import org.conqat.engine.abap.checks.EAbapNamingTarget;
import org.conqat.engine.core.core.ConQATException;
import org.jspecify.annotations.Nullable;

@Check(id="cqse-object-naming", languages={ELanguage.ABAP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ObjectNamingCheck
extends CheckImplementationBase {
    private static final String FUNCTION_LABEL = "Function";
    private static final String OBJECT_LABEL = "Object";
    private static final String TYPES = "PROG, CLAS, INTF, FUGR, FUMO, ALL";
    @CheckOption(name="Object Naming Rules", description="One naming rule per line in the form [Object Type];[Package Pattern];[Object Pattern]. Possible object types are PROG, CLAS, INTF, FUGR, FUMO, ALL. Any object whose package pattern matches must be named so that the object pattern matches as well. Within the object pattern, the (normalized) package name can be referred to as %{PACKAGE}. Patterns are treated case-insensitively.", multilineText=true)
    public List<String> rules = Arrays.asList("ALL;.*;.*");
    private static final Pattern RULE_SEPARATOR = Pattern.compile(";");
    private List<AbapObjectNamingRule> namingRules = new ArrayList<AbapObjectNamingRule>();

    public void initialize() throws CheckException {
        for (String rule : this.rules) {
            String[] ruleParts = RULE_SEPARATOR.split(rule);
            try {
                EAbapNamingTarget targetType = EAbapNamingTarget.valueOf(ruleParts[0]);
                this.namingRules.add(new AbapObjectNamingRule(ruleParts[1], ruleParts[2], targetType));
            }
            catch (IllegalArgumentException e) {
                throw new CheckException("'" + ruleParts[0] + "' is not a valid object type. Only permitted values are: PROG, CLAS, INTF, FUGR, FUMO, ALL", (Exception)e);
            }
        }
    }

    public void execute() throws CheckException {
        try {
            ParsedAbapElementPath path = new ParsedAbapElementPath(this.context.getUniformPath());
            this.checkPatternsAndCreateFinding(path.getElementName().getObjectName(), ObjectNamingCheck.getObjectPatterns(path, false, this.namingRules), OBJECT_LABEL);
            String functionName = this.getFunctionName();
            if (functionName != null) {
                this.checkPatternsAndCreateFinding(functionName, ObjectNamingCheck.getObjectPatterns(path, true, this.namingRules), FUNCTION_LABEL);
            }
        }
        catch (ConQATException e) {
            throw new CheckException((Exception)((Object)e));
        }
    }

    private @Nullable String getFunctionName() throws CheckException {
        List functions = ShallowEntityTraversalUtils.selectEntities((Collection)this.context.getAbstractSyntaxTree(ECodeViewOption.FILTERED), ObjectNamingCheck::isFunction);
        if (functions.isEmpty()) {
            return null;
        }
        String functionName = ((ShallowEntity)functions.get(0)).getName();
        if (functionName == null) {
            return null;
        }
        return functionName.toLowerCase();
    }

    private static boolean isFunction(ShallowEntity entity) {
        return entity.getType().equals((Object)EShallowEntityType.METHOD) && entity.getSubtype().equals("function");
    }

    private void checkPatternsAndCreateFinding(String name, List<Pattern> patterns, String label) throws CheckException {
        for (Pattern pattern : patterns) {
            if (pattern.matcher(name).matches()) continue;
            this.buildFinding(String.format("%s name '%s' violates naming rule '%s'", label, name, pattern.pattern()), this.buildLocation().forElement()).createAndStore();
        }
    }

    private static List<Pattern> getObjectPatterns(ParsedAbapElementPath path, boolean isFunctionName, List<AbapObjectNamingRule> namingRules) throws CheckException {
        ArrayList<Pattern> objectPatterns = new ArrayList<Pattern>();
        for (AbapObjectNamingRule rule : namingRules) {
            if (!rule.appliesTo(path, isFunctionName)) continue;
            objectPatterns.add(rule.patternForPackage(path.getPackageName()));
        }
        return objectPatterns;
    }
}

