/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.comment;

import eu.cqse.check.base.CommentCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.text.MessageFormat;
import java.util.List;
import java.util.Optional;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-comment-style", languages={ELanguage.JAVASCRIPT, ELanguage.JAVA, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.CS}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class CommentStyleCheck
extends CommentCheckBase {
    private static final FindingPropertyList RECOMMEND_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Use either '//' or '/* */' syntax consistently.");
    private static final String FINDING_MESSAGE_BLOCK_PATTERN = "Avoid block style comments {0} methods: {1}";
    private static final String FINDING_MESSAGE_EOL_PATTERN = "Avoid end-of-line style comments {0} methods: {1}";
    private static final String FINDING_LOCATION_INSIDE = "inside";
    private static final String FINDING_LOCATION_OUTSIDE = "outside";
    @CheckOption(name="Disallow End-of-line Comments inside Methods", description="Whether findings are created for end-of-line comments (e.g. `// My Comment`) inside methods")
    private boolean insideMethEoLOff = false;
    @CheckOption(name="Disallow Block Comments inside Methods", description="Whether findings are created for block comments (e.g.: `/* My Comment */`) inside methods")
    private boolean insideMethBlockOff = true;
    @CheckOption(name="Disallow End-of-line Comments outside Methods", description="Whether findings are created for end-of-line comments (e.g. `// My Comment`) outside methods")
    private boolean outsideMethEoLOff = false;
    @CheckOption(name="Disallow Block Comments outside Methods", description="Whether findings are created for block comments (e.g.: `/* My Comment */`) outside methods")
    private boolean outsideMethBlockOff = true;
    private List<ShallowEntity> methodEntList;

    public void execute() throws CheckException {
        this.methodEntList = ShallowEntityTraversalUtils.listMethodsNonRecursive((List)this.context.getRootEntity(ECodeViewOption.FILTERED).getChildren());
        super.execute();
    }

    protected void processComment(IToken token, int startLine, int endLine) {
        Optional containingMethodO = ShallowEntityTraversalUtils.findEntityForLineNonRec((int)startLine, this.methodEntList);
        if (containingMethodO.isPresent()) {
            ShallowEntity containingMethod = (ShallowEntity)containingMethodO.get();
            if (containingMethod.getStartOffset() < token.getOffset() && containingMethod.getEndOffset() > token.getOffset()) {
                if (token.getType() == ETokenType.TRADITIONAL_COMMENT && this.insideMethBlockOff) {
                    this.createFinding(FINDING_MESSAGE_BLOCK_PATTERN, FINDING_LOCATION_INSIDE, token);
                } else if (token.getType() == ETokenType.END_OF_LINE_COMMENT && this.insideMethEoLOff) {
                    this.createFinding(FINDING_MESSAGE_EOL_PATTERN, FINDING_LOCATION_INSIDE, token);
                }
            }
        } else {
            if (token.getType() == ETokenType.TRADITIONAL_COMMENT && this.outsideMethBlockOff) {
                this.createFinding(FINDING_MESSAGE_BLOCK_PATTERN, FINDING_LOCATION_OUTSIDE, token);
            }
            if (token.getType() == ETokenType.END_OF_LINE_COMMENT && this.outsideMethEoLOff) {
                this.createFinding(FINDING_MESSAGE_EOL_PATTERN, FINDING_LOCATION_OUTSIDE, token);
            }
        }
    }

    private void createFinding(String findingMessagePattern, String findingLocation, IToken commentToken) {
        String commentText = StringUtils.truncateWithEllipsis((String)commentToken.getText(), (int)100);
        String findingMessage = MessageFormat.format(findingMessagePattern, findingLocation, MarkupUtils.formatAsSourceCode((String)commentText));
        this.buildFinding(findingMessage, this.buildLocation().forToken(commentToken)).addFindingProperties(RECOMMEND_ACTION).createAndStore();
    }
}

