/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cross_language;

import eu.cqse.check.base.AvoidObjectComparisonWithSelfCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.LanguageGroups;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.util.clang.ClangUtils;
import eu.cqse.clang.CXCursor;
import eu.cqse.clang.CXTypeKind;
import eu.cqse.clang.Clang;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.lib.commons.assertion.CCSMAssert;

@Check(id="cqse-avoid-object-reference-comparison-with-self", languages={ELanguage.JAVASCRIPT, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.CS, ELanguage.JAVA, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP, ELanguage.PYTHON}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE, ECheckParameter.CLANG})
public class AvoidObjectReferenceComparisonWithSelfCheck
extends AvoidObjectComparisonWithSelfCheckBase {
    private static final ITokenMatcher CLIKE_DEFAULT_COMPARISON_OPERATORS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EQEQ, ETokenType.NOTEQ});
    private static final ITokenMatcher JAVASCRIPT_COMPARISON_OPERATORS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EQEQ, ETokenType.NOTEQ, ETokenType.EQEQEQ, ETokenType.NOTEQEQ});
    private static final ITokenMatcher PYTHON_COMPARISON_OPERATORS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EQEQ, ETokenType.NOTEQ, ETokenType.IS});

    private ITokenMatcher getComparisonOperators() {
        return switch (this.context.getLanguage()) {
            case ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.CS, ELanguage.JAVA, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP -> CLIKE_DEFAULT_COMPARISON_OPERATORS;
            case ELanguage.JAVASCRIPT -> JAVASCRIPT_COMPARISON_OPERATORS;
            case ELanguage.PYTHON -> PYTHON_COMPARISON_OPERATORS;
            default -> (ITokenMatcher)CCSMAssert.fail((String)("Language is not supported by check: " + String.valueOf(this.context.getLanguage())));
        };
    }

    protected List<Integer> getIndicesOfComparisonExpression(List<IToken> tokens) {
        return TokenStreamUtils.findAll(tokens, (ITokenMatcher)this.getComparisonOperators());
    }

    protected int getSecondOperandIndex(int index) {
        return index + 1;
    }

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    protected boolean isRuleException(IToken operand) {
        if (!LanguageGroups.C_CPP_AND_MS_CLI.contains(operand.getLanguage())) {
            return false;
        }
        if (EFeatureToggle.DISABLE_CLANG_JNI_CHECKS.isEnabled()) {
            return false;
        }
        CXCursor rootCursor = this.context.getClangTranslationUnitWrapper().getMainRootCursor();
        Optional cursor = ClangUtils.getCursorForToken((IToken)operand, (CXCursor)rootCursor);
        if (cursor.isEmpty()) {
            return false;
        }
        CXTypeKind type = Clang.clang_getCursorType((CXCursor)((CXCursor)cursor.get())).getKind();
        return type == CXTypeKind.CXType_Float || type == CXTypeKind.CXType_Float16 || type == CXTypeKind.CXType_Float128 || type == CXTypeKind.CXType_Double || type == CXTypeKind.CXType_LongDouble;
    }
}

