/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cs;

import eu.cqse.check.base.ThrowExceptionCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.List;

@Check(id="cqse-throw-highlevel-exceptions-cs", languages={ELanguage.CS}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ThrowHighlevelExceptionsCSCheck
extends ThrowExceptionCheckBase {
    protected String getFindingMessage(List<IToken> tokens) {
        return "Throw of generic exception ";
    }

    public boolean skipMethod(ShallowEntity entity) {
        return false;
    }

    public boolean createFindingForException(List<IToken> tokens, String exceptionClassName) {
        return LanguageFeatureParser.CS.isGenericExceptionClass(exceptionClassName);
    }
}

