/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.general;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.EnumSet;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-missing-code", languages={ELanguage.ABAP, ELanguage.ADA, ELanguage.COBOL, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.CS, ELanguage.DELPHI, ELanguage.HANA_VIEW, ELanguage.FORTRAN, ELanguage.GO, ELanguage.GROOVY, ELanguage.IEC61131, ELanguage.JAVA, ELanguage.JAVASCRIPT, ELanguage.LINE, ELanguage.MATLAB, ELanguage.OPEN_CL, ELanguage.OSCRIPT, ELanguage.PHP, ELanguage.PLSQL, ELanguage.PYTHON, ELanguage.RUST, ELanguage.SQLSCRIPT, ELanguage.VB, ELanguage.XML, ELanguage.XTEND, ELanguage.SWIFT, ELanguage.GOSU, ELanguage.KOTLIN, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP, ELanguage.TSQL, ELanguage.ESQL})
public class MissingCodeCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "File does not contain any code";
    private static final SetMap<ELanguage, String> IGNORED_FILENAMES_BY_LANGUAGE = new SetMap();
    private static final EnumSet<ETokenType.ETokenClass> COMMENT_TOKEN_CLASSES;

    public void execute() throws CheckException {
        if (IGNORED_FILENAMES_BY_LANGUAGE.contains((Object)this.context.getLanguage(), (Object)UniformPathUtils.getElementName((String)this.context.getUniformPath()))) {
            return;
        }
        for (IToken token : this.context.getTokens(ECodeViewOption.FILTERED)) {
            if (COMMENT_TOKEN_CLASSES.contains(token.getType().getTokenClass()) || StringUtils.isEmpty((String)token.getText())) continue;
            return;
        }
        int filteredLength = this.context.getTextContent(ECodeViewOption.ETextViewOption.FILTERED_CONTENT).length();
        int unfilteredLength = this.context.getTextContent(ECodeViewOption.ETextViewOption.UNFILTERED_CONTENT).length();
        if (unfilteredLength > filteredLength) {
            return;
        }
        this.buildFinding(FINDING_MESSAGE, this.buildLocation().forElement()).createAndStore();
    }

    static {
        IGNORED_FILENAMES_BY_LANGUAGE.add((Object)ELanguage.PYTHON, (Object)"__init__.py");
        COMMENT_TOKEN_CLASSES = EnumSet.of(ETokenType.ETokenClass.COMMENT, ETokenType.ETokenClass.SYNTHETIC, ETokenType.ETokenClass.WHITESPACE);
    }
}

