/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.typetracker.ITypeResolution;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.JavaExpressionTypeExtractor;
import eu.cqse.check.framework.util.JavaMethodCallMatcher;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.List;
import java.util.Optional;

@Check(id="cqse-avoid-creating-simple-date-format-without-locale", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE, ECheckParameter.TYPE_RESOLUTION})
public class AvoidCreatingSimpleDateFormatWithoutLocaleCheck
extends CheckImplementationBase {
    private static final String SIMPLE_DATE_FORMAT_FULL_CLASS_NAME = "java.text.SimpleDateFormat";
    private static final String LOCALE_FULL_CLASS_NAME = "java.util.Locale";
    private static final String FINDING_MESSAGE = "`SimpleDateFormat` constructor should specify `Locale`";
    private static final JavaMethodCallMatcher SIMPLE_DATE_CONSTRUCTOR_MATCHER = JavaMethodCallMatcher.create().onTypes(new String[]{"java.text.SimpleDateFormat"}).constructors();

    public void execute() throws CheckException {
        if (!LanguageFeatureParser.JAVA.usesImportedType((List)this.getRootChildren(), SIMPLE_DATE_FORMAT_FULL_CLASS_NAME)) {
            return;
        }
        JavaImportSensitiveTypeResolver typeResolver = new JavaImportSensitiveTypeResolver(this.context.getRootEntity(this.getCodeViewOption()));
        for (JavaMethodCallMatcher.MethodCall simpleDateInstantiation : SIMPLE_DATE_CONSTRUCTOR_MATCHER.find(this.context, typeResolver)) {
            if (simpleDateInstantiation.parameters().size() == 2 && this.typeIsLocale(simpleDateInstantiation.entity(), (List)simpleDateInstantiation.parameters().get(1), typeResolver)) continue;
            this.buildFinding(FINDING_MESSAGE, this.buildLocation().forToken(simpleDateInstantiation.token())).createAndStore();
        }
    }

    private boolean typeIsLocale(ShallowEntity statement, List<IToken> tokens, JavaImportSensitiveTypeResolver typeResolver) throws CheckException {
        Optional parameterType = JavaExpressionTypeExtractor.inferExpressionResultType((ShallowEntity)statement, tokens, (ITypeResolution)this.context.getTypeResolution(this.getCodeViewOption()), (JavaImportSensitiveTypeResolver)typeResolver);
        if (parameterType.isPresent()) {
            return ((JavaExpressionTypeExtractor.InferTypeResult)parameterType.get()).inferredType().equals(LOCALE_FULL_CLASS_NAME);
        }
        return TokenStreamTextUtils.concatTokenTexts(tokens).matches(".*[Ll]ocale.*");
    }
}

