/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.tests;

import eu.cqse.check.clike.CatchExceptionCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.jspecify.annotations.Nullable;

@Check(id="java:S5779", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class CatchAssertionsCheck
extends CheckImplementationBase {
    private static final Set<String> EXCEPTION_NAMES = CatchAssertionsCheck.getExceptionNames();

    private static UnmodifiableSet<String> getExceptionNames() {
        HashSet<String> names = new HashSet<String>(LanguageFeatureParser.JAVA.generateExceptionNamesSet(new Class[]{AssertionError.class, Throwable.class, Error.class}));
        names.add("AssertionFailedError");
        names.add("junit.framework.AssertionFailedError");
        names.add("org.opentest4j.AssertionFailedError");
        names.add("MultipleFailuresError");
        names.add("org.opentest4j.MultipleFailuresError");
        names.add("org.assertj.core.api.AssertionError");
        return UnmodifiableSet.of(names);
    }

    public void execute() throws CheckException {
        List ast = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        List importStatements = LanguageFeatureParser.JAVA.getImportStatements(ast);
        Set staticImportedAssertionMethods = LanguageFeatureParser.JAVA.extractStaticImportedAssertions(importStatements);
        Set importedAssertionTypes = LanguageFeatureParser.JAVA.extractImportedAssertionsTypes(importStatements);
        List statements = ShallowEntityTraversalUtils.findNestedEntities((List)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD, entity -> true, (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (!"catch".equals(statement.getSubtype())) continue;
            this.processCatch(statement, importedAssertionTypes, staticImportedAssertionMethods);
        }
    }

    private void processCatch(ShallowEntity entity, Set<String> importedAssertionTypes, Set<String> staticImportedAssertionMethods) {
        List catchArgumentTokens = TokenStreamUtils.tokensBetween((List)entity.ownStartTokens(), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
        Set<String> exceptionNames = CatchAssertionsCheck.getExceptionClassNames(catchArgumentTokens);
        this.createFindingForException(exceptionNames, entity, importedAssertionTypes, staticImportedAssertionMethods);
    }

    private static Set<String> getExceptionClassNames(List<IToken> catchArgumentTokens) {
        int endOfClassName;
        HashSet<String> exceptionNames = new HashSet<String>();
        int numberOfTokens = catchArgumentTokens.size();
        if (numberOfTokens == 0) {
            return exceptionNames;
        }
        int currentIndex = 0;
        while ((endOfClassName = CatchExceptionCheckBase.findLastTokenIndexOfClassName(catchArgumentTokens, (int)currentIndex)) != -1) {
            List<IToken> typeTokens = catchArgumentTokens.subList(currentIndex, endOfClassName + 1);
            String className = TokenStreamTextUtils.concatTokenTexts(typeTokens);
            exceptionNames.add(className);
            if (numberOfTokens > endOfClassName + 1 && catchArgumentTokens.get(endOfClassName + 1).getType() == ETokenType.OR && (currentIndex = endOfClassName + 2) < numberOfTokens) continue;
        }
        return exceptionNames;
    }

    private void createFindingForException(Set<String> classNames, ShallowEntity catchEntity, Set<String> importedAssertionTypes, Set<String> staticImportedAssertionMethods) {
        if (CollectionUtils.intersectionSet(classNames, (Collection[])new Collection[]{EXCEPTION_NAMES}).isEmpty()) {
            return;
        }
        if (CatchAssertionsCheck.isExceptionInstanceUsed(catchEntity)) {
            return;
        }
        this.createFindingForAssertionCallsInTryStatement(catchEntity, importedAssertionTypes, staticImportedAssertionMethods);
    }

    private static boolean isExceptionInstanceUsed(ShallowEntity catchEntity) {
        IToken exceptionIdentifier = CatchAssertionsCheck.getExceptionInstance(catchEntity);
        if (exceptionIdentifier == null) {
            return true;
        }
        List<IToken> catchBody = CatchAssertionsCheck.getCatchBody(catchEntity);
        IToken tokenByTypeAndText = TokenStreamUtils.getTokenByTypeAndText(catchBody, (String)exceptionIdentifier.getText(), Set.of(ETokenType.IDENTIFIER));
        return tokenByTypeAndText != null;
    }

    private static @Nullable IToken getExceptionInstance(ShallowEntity catchEntity) {
        UnmodifiableList catchTokens = catchEntity.ownStartTokens();
        TokenPattern exceptionInstancePattern = new TokenPattern().sequence(new Object[]{ETokenType.CATCH, ETokenType.LPAREN}).skipTo(new Object[]{new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER, ETokenType.RPAREN})}).group(0);
        TokenPatternMatch firstMatch = exceptionInstancePattern.findFirstMatch((List)catchTokens);
        if (firstMatch == null) {
            return null;
        }
        return (IToken)firstMatch.groupTokens(0).getFirst();
    }

    private static List<IToken> getCatchBody(ShallowEntity catchEntity) {
        return catchEntity.includedTokens().subList(catchEntity.includedTokens().indexOf(catchEntity.ownStartTokens().getLast()), catchEntity.includedTokens().size());
    }

    private void createFindingForAssertionCallsInTryStatement(ShallowEntity catchEntity, Set<String> importedAssertionTypes, Set<String> staticImportedAssertionMethods) {
        ShallowEntity tryEntity = LanguageFeatureParser.JAVA.findTryStatement(catchEntity);
        if (tryEntity == null) {
            return;
        }
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType(List.of(tryEntity), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            List assertionCalls = LanguageFeatureParser.JAVA.getAssertionCalls(statement, importedAssertionTypes, staticImportedAssertionMethods);
            for (IToken assertionCall : assertionCalls) {
                this.buildFinding("Don't throw assertions inside a try-catch catching an AssertionError.", this.buildLocation().forToken(assertionCall)).createAndStore();
            }
        }
    }
}

